/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.cache.CacheStatistics;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;

public class EhCacheStatisticsManager
implements CacheStatisticsManager {
    private static final String CACHE_NAME_PREFIX = "cache.name.";
    private final I18NBeanFactory i18NBeanFactory;

    public EhCacheStatisticsManager(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public List<CacheStatistics> getLocalCacheStatistics() {
        ArrayList<CacheStatistics> cacheStatistics = new ArrayList<CacheStatistics>();
        CacheManager cacheManager = CacheManager.getInstance();
        I18NBean i18nBean = this.i18NBeanFactory.getI18NBean();
        for (String cacheName : cacheManager.getCacheNames()) {
            Cache cache = cacheManager.getCache(cacheName);
            cacheStatistics.add(new EhCacheStatistics(cache, i18nBean.getText(CACHE_NAME_PREFIX + cacheName)));
        }
        Collections.sort(cacheStatistics, new Comparator<CacheStatistics>(){

            @Override
            public int compare(CacheStatistics o1, CacheStatistics o2) {
                String name1 = o1.getNiceName() != null ? o1.getNiceName() : o1.getName();
                String name2 = o2.getNiceName() != null ? o2.getNiceName() : o2.getName();
                return name1.compareTo(name2);
            }
        });
        return cacheStatistics;
    }

    public CacheStatistics getLocalCacheStatistics(String cacheName) {
        CacheManager cacheManager = CacheManager.getInstance();
        Cache cache = cacheManager.getCache(cacheName);
        I18NBean i18nBean = this.i18NBeanFactory.getI18NBean();
        return new EhCacheStatistics(cache, i18nBean.getText(CACHE_NAME_PREFIX + cacheName));
    }

    private static class EhCacheStatistics
    implements CacheStatistics {
        private final String name;
        private final long hitCount;
        private final long notFoundCount;
        private final long expiredCount;
        private final long size;
        private final String niceName;
        private final int maxSize;

        public EhCacheStatistics(Cache cache, String niceName) throws CacheException {
            this.niceName = niceName;
            this.name = cache.getName();
            this.hitCount = cache.getStatistics().getCacheHits();
            this.notFoundCount = cache.getStatistics().getCacheMisses();
            this.expiredCount = cache.getStatistics().getEvictionCount();
            this.size = cache.getSize();
            this.maxSize = cache.getCacheConfiguration().getMaxElementsInMemory();
        }

        public boolean hasContents() {
            return this.size > 0L;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getExpiredCount() {
            return this.expiredCount;
        }

        public long getAccessCount() {
            return this.hitCount + this.notFoundCount + this.expiredCount;
        }

        public long getMissCount() {
            return this.notFoundCount + this.expiredCount;
        }

        public int getHitPercent() {
            return this.asPercentage(this.hitCount, this.getAccessCount());
        }

        public long getSize() {
            return this.size;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public String getName() {
            return this.name;
        }

        public int getUsagePercent() {
            if (this.getAccessCount() == 0L) {
                return 0;
            }
            return (int)((float)this.getSize() / (float)this.getMaxSize() * 100.0f);
        }

        public String getNiceName() {
            return this.niceName;
        }

        private int asPercentage(long numerator, long denominator) {
            return denominator > 0L ? (int)((double)numerator / (double)denominator * 100.0) : 0;
        }
    }
}

