/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.configurable.ObjectConfigurationProperty;
import com.atlassian.configurable.ObjectDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class ObjectConfigurationImpl
implements ObjectConfiguration {
    private final ObjectDescriptor od;
    private final Map configProperties = Collections.synchronizedMap(new ListOrderedMap());
    private final Map params = Collections.synchronizedMap(new ListOrderedMap());

    public ObjectConfigurationImpl(String id, Map configProperties, ObjectDescriptor od) {
        this(configProperties, od);
    }

    public ObjectConfigurationImpl(Map configProperties, ObjectDescriptor od) {
        this.configProperties.putAll(configProperties);
        this.od = od;
    }

    public void init(Map params) {
        this.params.clear();
        if (params != null) {
            this.params.putAll(params);
        }
    }

    public String getFieldName(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return ((ObjectConfigurationProperty)this.configProperties.get(key)).getName();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public String getFieldDescription(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return ((ObjectConfigurationProperty)this.configProperties.get(key)).getDescription();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public String getFieldDefault(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return ((ObjectConfigurationProperty)this.configProperties.get(key)).getDefault();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public int getFieldType(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return new Integer(((ObjectConfigurationProperty)this.configProperties.get(key)).getType());
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public Map getFieldValues(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            ObjectConfigurationProperty objectConfigurationProperty = (ObjectConfigurationProperty)this.configProperties.get(key);
            objectConfigurationProperty.init(this.params);
            return objectConfigurationProperty;
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public String[] getFieldKeys() {
        String[] returnValue = new String[this.configProperties.size()];
        int counter = 0;
        Iterator iterator = this.configProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            returnValue[counter] = key = (String)iterator.next();
            ++counter;
        }
        return returnValue;
    }

    public String[] getEnabledFieldKeys() {
        ArrayList returnValue = new ArrayList();
        Iterator iterator = this.configProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((ObjectConfigurationProperty)entry.getValue()).isEnabled()) continue;
            returnValue.add(entry.getKey());
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public boolean isEnabled(String key) {
        ObjectConfigurationProperty property = (ObjectConfigurationProperty)this.configProperties.get(key);
        return property != null && property.isEnabled();
    }

    public String getDescription(Map params) {
        return this.od.getDescription(this.configProperties, params);
    }

    public boolean allFieldsHidden() {
        if (this.configProperties != null) {
            Iterator iterator = this.configProperties.values().iterator();
            while (iterator.hasNext()) {
                ObjectConfigurationProperty ocp = (ObjectConfigurationProperty)iterator.next();
                if (ocp.getType() == 3) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isI18NValues(String key) {
        return this.configProperties.containsKey(key) && ((ObjectConfigurationProperty)this.configProperties.get(key)).isI18nValues();
    }
}

