/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.analytics.events.def;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.EventValidationResult;
import com.atlassian.cmpt.analytics.events.EventValidationUtils;
import com.atlassian.cmpt.analytics.events.OperationalEventDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DetectedUserEmailOperationalEvent
extends OperationalEventDto {
    public static final String ATTR_USER_STATUS = "userStatus";
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_DISABLED = "disabled";
    private static final List<String> VALID_VALUES_FOR_USER_STATUS = Arrays.asList("active", "disabled");

    private DetectedUserEmailOperationalEvent(Builder builder) {
        super(builder);
    }

    @Override
    public EventValidationResult validate() {
        ArrayList<EventValidationResult.EventValidationItem> errors = new ArrayList<EventValidationResult.EventValidationItem>();
        EventValidationUtils.checkAttributeIsSet(ATTR_USER_STATUS, this, errors);
        EventValidationUtils.checkAttributeHasValidValues(ATTR_USER_STATUS, this, VALID_VALUES_FOR_USER_STATUS, errors);
        if (StringUtils.isEmpty((CharSequence)this.cloudId)) {
            errors.add(new EventValidationResult.EventValidationItem("cloudId", "", "cloudId not set"));
        }
        return new EventValidationResult(errors);
    }

    public static class Builder
    extends OperationalEventDto.Builder<Builder, DetectedUserEmailOperationalEvent> {
        public Builder(long timestamp, String email) {
            super(timestamp);
            this.action("detected");
            this.actionSubject("userEmail", EventDto.hashEmail(email));
        }

        public Builder userStatus(boolean active) {
            this.addAttribute(DetectedUserEmailOperationalEvent.ATTR_USER_STATUS, active ? DetectedUserEmailOperationalEvent.STATUS_ACTIVE : DetectedUserEmailOperationalEvent.STATUS_DISABLED);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DetectedUserEmailOperationalEvent build() {
            return this.validate(new DetectedUserEmailOperationalEvent(this));
        }
    }
}

