/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.analytics.events;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;

public class EventValidationResult {
    public static final EventValidationResult OK = new EventValidationResult(null);
    public final List<EventValidationItem> errors;

    public EventValidationResult(@Nullable List<EventValidationItem> errors) {
        this.errors = CollectionUtils.isNotEmpty(errors) ? Collections.unmodifiableList(errors) : Collections.emptyList();
    }

    public boolean isValid() {
        return CollectionUtils.isEmpty(this.errors);
    }

    public String getErrorsAsString() {
        return this.errors.stream().map(e -> e.message).collect(Collectors.joining("; "));
    }

    public static class EventValidationItem {
        public final String fieldName;
        public final String fieldValue;
        public final String message;

        public EventValidationItem(String fieldName, String fieldValue, String message) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
            this.message = message;
        }
    }
}

