/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.classloader;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatResourceEntriesCacheFlusher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TomcatResourceEntriesCacheFlusher.class);
    private static final String TOMCAT_CLASSLOADER_NAME = "WebappClassLoader";
    public static final String RESOURCE_ENTRIES_FIELD = "resourceEntries";

    @Override
    public void run() {
        try {
            ClassLoader classloader = this.getClassLoader();
            String classLoaderName = classloader.getClass().getName();
            if (classLoaderName.contains(TOMCAT_CLASSLOADER_NAME)) {
                this.clearResourceEntries(classloader);
            } else {
                log.warn("Expected tomcat WebappClassLoader but found " + classLoaderName + " - not flushing its cache");
            }
        }
        catch (Exception e) {
            log.warn("Problem trying to flush tomcat classloader cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearResourceEntries(ClassLoader classloader) throws NoSuchFieldException, IllegalAccessException {
        HashMap resourceEntries;
        log.debug("Flushing Tomcat WebappClassLoader resource entries");
        Field field = classloader.getClass().getDeclaredField(RESOURCE_ENTRIES_FIELD);
        field.setAccessible(true);
        HashMap hashMap = resourceEntries = (HashMap)field.get(classloader);
        synchronized (hashMap) {
            resourceEntries.clear();
        }
    }

    ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

