/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.cache.memory.jmx.MemoryCacheMXBeanRegistrar;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MBeanServer;

public class JMXMemoryCacheManager
extends MemoryCacheManager
implements MBeanRegistrar {
    private final MemoryCacheMXBeanRegistrar mbeansRegistrar = new MemoryCacheMXBeanRegistrar();
    private ManagedLock.ReadWrite metricsLock = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());

    public JMXMemoryCacheManager() {
    }

    public JMXMemoryCacheManager(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        super(cacheSettingsDefaultsProvider);
    }

    @Override
    protected void putCacheInMap(@Nonnull String name, @Nonnull Supplier<ManagedCache> supplier) {
        this.metricsLock.read().withLock(() -> {
            JMXMemoryCacheManager.super.putCacheInMap(name, supplier);
            this.mbeansRegistrar.registerMBean(name);
        });
    }

    public void registerMBeans(@Nullable MBeanServer mBeanServer) {
        this.metricsLock.write().withLock(() -> this.mbeansRegistrar.enableCollectingJMXMetrics(mBeanServer, (CacheManager)this));
    }

    public void unregisterMBeans(@Nullable MBeanServer mBeanServer) {
        this.metricsLock.write().withLock(() -> this.mbeansRegistrar.unregisterMBeans());
    }
}

