/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.cache.memory.jmx.MemoryCacheMXBeanRegistrar;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MBeanServer;

public class JMXMemoryCacheManager
extends MemoryCacheManager
implements MBeanRegistrar {
    private final MemoryCacheMXBeanRegistrar mbeansRegistrar = new MemoryCacheMXBeanRegistrar();
    private ManagedLock.ReadWrite metricsLock = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());

    public JMXMemoryCacheManager() {
    }

    public JMXMemoryCacheManager(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        super(cacheSettingsDefaultsProvider);
    }

    @Override
    protected void putCacheInMap(@Nonnull String name, @Nonnull Supplier<ManagedCache> supplier) {
        this.metricsLock.read().withLock(() -> {
            JMXMemoryCacheManager.access$001(this, name, supplier);
            this.mbeansRegistrar.registerMBean(name);
        });
    }

    public void registerMBeans(@Nullable MBeanServer mBeanServer) {
        this.metricsLock.write().withLock(() -> this.mbeansRegistrar.enableCollectingJMXMetrics(mBeanServer, (CacheManager)this));
    }

    public void unregisterMBeans(@Nullable MBeanServer mBeanServer) {
        this.metricsLock.write().withLock(() -> this.mbeansRegistrar.unregisterMBeans());
    }

    static /* synthetic */ void access$001(JMXMemoryCacheManager x0, String x1, Supplier x2) {
        super.putCacheInMap(x1, (Supplier<ManagedCache>)x2);
    }
}

