package com.atlassian.cache.memory.jmx;

/**
 * JMX MBean interface for Guava Cache.
 *
 * @since v3.1
 */
public interface MemoryCacheMXBean
{
    /**
     * Returns the number of times Cache lookup methods have returned either a cached or uncached value.
     *
     * @return request count
     */
    long getRequestCount();

    /**
     * Returns the number of times Cache lookup methods have returned a cached value.
     *
     * @return hit count
     */
    long getHitCount();

    /**
     * Returns the ratio of cache requests which were hits.
     *
     * @return hit ratio
     */
    double getHitRate();

    /**
     * Returns the number of times Cache lookup methods have returned an uncached (newly loaded) value, or null.
     *
     * @return miss count
     */
    long getMissCount();

    /**
     * Returns the ratio of cache requests which were misses.
     *
     * @return miss rate
     */
    double getMissRate();

    /**
     * Returns the total number of times that Cache lookup methods attempted to load new values.
     *
     * @return load count
     */
    long getLoadCount();

    /**
     * Returns the number of times Cache lookup methods have successfully loaded a new value.
     *
     * @return load success count
     */
    long getLoadSuccessCount();

    /**
     * Returns the number of times Cache lookup methods threw an exception while loading a new value.
     *
     * @return load exception count
     */
    long getLoadExceptionCount();

    /**
     * Returns the ratio of cache loading attempts which threw exceptions.
     *
     * @return load exception rate
     */
    double getLoadExceptionRate();

    /**
     * Returns the total number of nanoseconds the cache has spent loading new values.
     *
     * @return total load time
     */
    long getTotalLoadTime();

    /**
     * Returns the average time spent loading new values.
     *
     * @return average load penalty
     */
    double getAverageLoadPenalty();

    /**
     * Returns the number of times an entry has been evicted.
     *
     * @return eviction count
     */
    long getEvictionCount();

    /**
     * Returns the number of cached objects
     *
     * @return size
     */
    long getSize();

}
