/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheException;
import com.atlassian.cache.LazyReference;
import com.atlassian.cache.LazyReferenceBuilder;
import com.atlassian.cache.memory.DelegatingLazyReference;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.cache.memory.ReferenceKey;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryLazyReferenceBuilder<V>
extends LazyReferenceBuilder<V> {
    protected final MemoryCacheManager factory;

    public MemoryLazyReferenceBuilder(@NotNull String name, MemoryCacheManager factory) {
        super(name);
        this.factory = factory;
    }

    public LazyReference<V> build() {
        return this.factory.getLazyReference(this);
    }

    LazyReference<V> createLazyReference(String name) {
        if (this.supplier == null) {
            throw new CacheException("You can't create a computing cache, without a supplier");
        }
        MapMaker mapMaker = new MapMaker();
        ConcurrentMap computingCache = mapMaker.makeComputingMap(new Function<ReferenceKey, V>(){

            public V apply(@Nullable ReferenceKey key) {
                return MemoryLazyReferenceBuilder.this.supplier.get();
            }
        });
        return new DelegatingLazyReference(computingCache, name);
    }
}

