/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheException;
import com.atlassian.cache.LazyReference;
import com.atlassian.cache.memory.ReferenceKey;
import com.google.common.collect.ComputationException;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingLazyReference<V>
implements LazyReference<V> {
    private final ConcurrentMap<ReferenceKey, V> internalCache;
    private final String name;

    public DelegatingLazyReference(ConcurrentMap<ReferenceKey, V> internalCache, String name) {
        this.internalCache = internalCache;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public V get() {
        try {
            return this.internalCache.get(ReferenceKey.KEY);
        }
        catch (ComputationException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void reset() {
        try {
            this.internalCache.remove(ReferenceKey.KEY);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        this.reset();
    }

    public boolean isFlushable() {
        return true;
    }

    public boolean equals(@Nullable Object object) {
        return this.internalCache.equals(object);
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }
}

