/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.google.common.collect.ComputationException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingCache<K, V>
implements Cache<K, V> {
    private final ConcurrentMap<K, V> internalCache;
    private final String name;
    private final boolean flushable;

    public DelegatingCache(ConcurrentMap<K, V> internalCache, String name, boolean flushable) {
        this.internalCache = internalCache;
        this.name = name;
        this.flushable = flushable;
    }

    public String getName() {
        return this.name;
    }

    public Collection<K> getKeys() {
        try {
            return this.internalCache.keySet();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(K key, V value) {
        try {
            this.internalCache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V get(K key) {
        try {
            return this.internalCache.get(key);
        }
        catch (ComputationException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void remove(K key) {
        try {
            this.internalCache.remove(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void removeAll() {
        try {
            this.internalCache.clear();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        this.removeAll();
    }

    public boolean isFlushable() {
        return this.flushable;
    }

    public boolean equals(@Nullable Object object) {
        return this.internalCache.equals(object);
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }
}

