package com.atlassian.cache.ehcache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class SynchronizedLoadingCacheDecorator extends EhcacheDecoratorAdapter {

    private static final Object LOAD_PLACEHOLDER = new Object();

    private final Map synchronizationMap = new ConcurrentHashMap<>();

    public SynchronizedLoadingCacheDecorator(final Ehcache delegate) {
        super(delegate);
    }

    @SuppressWarnings("unchecked")
    protected <V> Element synchronizedLoad(Object key, Function<Object, V> loader, Consumer<Element> postLoadProcessor) {
        Element result;
        V value = null;
        try {
            synchronizationMap.put(key, LOAD_PLACEHOLDER);
            value = loader.apply(key);
        } finally {
            result = new Element(key, value);
            synchronizationMap.computeIfPresent(key, (a, b) -> {
                postLoadProcessor.accept(result);
                return null;
            });

        }
        return result;
    }

    @Override
    public boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) {
        synchronizationMap.remove(key);
        return super.remove(key, doNotNotifyCacheReplicators);
    }

    @Override
    public boolean remove(Serializable key) {
        synchronizationMap.remove(key);
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, final boolean doNotNotifyCacheReplicators) {
        synchronizationMap.remove(key);
        return super.remove(key, doNotNotifyCacheReplicators);
    }

    @Override
    public boolean remove(Object key) {
        synchronizationMap.remove(key);
        return super.remove(key);
    }

    @Override
    public void removeAll() {
        synchronizationMap.clear();
        super.removeAll();
    }

    @Override
    public void removeAll(boolean doNotNotifyCacheReplicators) {
        synchronizationMap.clear();
        super.removeAll(doNotNotifyCacheReplicators);
    }
}
