package com.atlassian.cache.ehcache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.loader.CacheLoader;

/**
* A delegating loader for EhCache.
*
* @since v2.0.8
*/
class DelegatingCacheLoader<K, V> implements CacheLoader, Cloneable
{
    private com.atlassian.cache.CacheLoader<K, V> loader;

    public DelegatingCacheLoader(final com.atlassian.cache.CacheLoader<K, V> loader)
    {
        this.loader = loader;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object load(final Object key) throws net.sf.ehcache.CacheException
    {
        return loader.load((K) key);
    }

    @SuppressWarnings("unchecked")
    @Override
    public Map loadAll(final Collection keys)
    {
        Map<K, V> map = new HashMap<K, V>();
        for (Object key : keys)
        {
            final V value = loader.load((K) key);
            if (value != null)
            {
                map.put((K) key, value);
            }
        }
        return map;
    }

    @Override
    public Object load(final Object key, final Object argument)
    {
        return load(key);
    }

    @Override
    public Map loadAll(final Collection keys, final Object argument)
    {
        return loadAll(keys);
    }

    @Override
    public String getName()
    {
        return loader.getClass().getName();
    }

    @Override
    public CacheLoader clone(final Ehcache cache) throws CloneNotSupportedException
    {
        return (CacheLoader) super.clone();
    }

    @Override
    public void init()
    {

    }

    @Override
    public void dispose() throws net.sf.ehcache.CacheException
    {
        loader = null;
    }

    @Override
    public Status getStatus()
    {
        return loader == null ? Status.STATUS_ALIVE : Status.STATUS_UNINITIALISED;
    }
}
