/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ManagedCache;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Ehcache;

abstract class ManagedCacheSupport
implements ManagedCache {
    private final Ehcache delegate;
    private final CacheSettings settings;

    public ManagedCacheSupport(Ehcache delegate, CacheSettings settings) {
        this.delegate = delegate;
        this.settings = settings;
    }

    public final String getName() {
        return this.delegate.getName();
    }

    public final boolean isFlushable() {
        return this.settings.getFlushable(true);
    }

    public final boolean isLocal() {
        return this.settings.getLocal(false);
    }

    public final boolean isReplicateAsynchronously() {
        return this.settings.getReplicateAsynchronously(false);
    }

    public final boolean isReplicateViaCopy() {
        return this.settings.getReplicateViaCopy(false);
    }

    public final Integer currentMaxEntries() {
        return (int)this.delegate.getCacheConfiguration().getMaxEntriesLocalHeap();
    }

    public final boolean updateMaxEntries(int newValue) {
        this.delegate.getCacheConfiguration().setMaxEntriesLocalHeap((long)newValue);
        return true;
    }

    public final Long currentExpireAfterAccessMillis() {
        return TimeUnit.MILLISECONDS.convert(this.delegate.getCacheConfiguration().getTimeToIdleSeconds(), TimeUnit.SECONDS);
    }

    public final boolean updateExpireAfterAccess(long expireAfter, TimeUnit timeUnit) {
        this.delegate.getCacheConfiguration().setTimeToIdleSeconds(timeUnit.toSeconds(expireAfter));
        return true;
    }

    public final Long currentExpireAfterWriteMillis() {
        return TimeUnit.MILLISECONDS.convert(this.delegate.getCacheConfiguration().getTimeToLiveSeconds(), TimeUnit.SECONDS);
    }

    public final boolean updateExpireAfterWrite(long expireAfter, TimeUnit timeUnit) {
        this.delegate.getCacheConfiguration().setTimeToLiveSeconds(timeUnit.toSeconds(expireAfter));
        return true;
    }
}

