/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ehcache.RMICacheReplicatorFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;

class EhCacheHelper {
    private static final String CACHE_PROPERTIES = "replicateAsynchronously=%s,replicatePuts=%s,replicatePutsViaCopy=%s,replicateUpdates=%s,replicateUpdatesViaCopy=%s,replicateRemovals=true";
    static final PersistenceConfiguration.Strategy PERSISTENCE_STRATEGY = PersistenceConfiguration.Strategy.NONE;
    private static final PersistenceConfiguration PERSISTENCE_CONFIGURATION = new PersistenceConfiguration().strategy(PERSISTENCE_STRATEGY);
    private static final String URL_ENCODING = "UTF-8";

    EhCacheHelper() {
    }

    private static CacheConfiguration.CacheEventListenerFactoryConfiguration getCacheEventListenerFactoryConfiguration(CacheSettings settings, boolean selfLoading) {
        boolean replicateAsynchronously = settings.getReplicateAsynchronously(false);
        boolean replicateViaCopy = settings.getReplicateViaCopy(false);
        boolean replicatePuts = !selfLoading;
        boolean replicateUpdates = !selfLoading;
        String cacheProperties = String.format(CACHE_PROPERTIES, replicateAsynchronously, replicatePuts, replicateViaCopy, replicateUpdates, replicateViaCopy);
        return (CacheConfiguration.CacheEventListenerFactoryConfiguration)((CacheConfiguration.CacheEventListenerFactoryConfiguration)new CacheConfiguration.CacheEventListenerFactoryConfiguration().className(RMICacheReplicatorFactory.class.getName())).properties(cacheProperties);
    }

    Ehcache getEhcache(String name, CacheManager ehMgr, CacheSettings settings, boolean selfLoading) {
        CacheConfiguration config = ehMgr.getConfiguration().getDefaultCacheConfiguration().clone().name(name).statistics(true).persistence(PERSISTENCE_CONFIGURATION);
        boolean replicateCache = this.isReplicateCache(ehMgr, settings);
        if (replicateCache) {
            config.cacheEventListenerFactory(EhCacheHelper.getCacheEventListenerFactoryConfiguration(settings, selfLoading));
        }
        if (null != settings.getMaxEntries()) {
            config.setMaxEntriesLocalHeap((long)settings.getMaxEntries().intValue());
        }
        if (null != settings.getExpireAfterAccess()) {
            config.timeToIdleSeconds(TimeUnit.SECONDS.convert(settings.getExpireAfterAccess(), TimeUnit.MILLISECONDS));
        }
        if (null != settings.getExpireAfterWrite()) {
            config.timeToLiveSeconds(TimeUnit.SECONDS.convert(settings.getExpireAfterWrite(), TimeUnit.MILLISECONDS));
        }
        if (settings.getExpireAfterAccess() != null || settings.getExpireAfterWrite() != null) {
            config.setEternal(false);
        }
        ehMgr.addCacheIfAbsent((Ehcache)new Cache(config));
        return ehMgr.getCache(this.getCacheName(name, replicateCache));
    }

    private String getCacheName(String name, boolean replicateCache) {
        if (replicateCache) {
            try {
                return URLEncoder.encode(name, URL_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return name;
    }

    private boolean isReplicateCache(CacheManager ehMgr, CacheSettings settings) {
        boolean isLocalCacheSetting = settings.getLocal(false);
        return !isLocalCacheSetting && ehMgr.getCacheManagerPeerProvider("RMI") != null;
    }
}

