/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.ehcache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ehcache.ManagedCacheSupport;
import com.atlassian.util.concurrent.NotNull;
import java.util.Collection;
import javax.annotation.Nullable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

class DelegatingCache<K, V>
extends ManagedCacheSupport
implements Cache<K, V> {
    private final Ehcache delegate;

    private DelegatingCache(Ehcache delegate, CacheSettings settings) {
        super(delegate, settings);
        this.delegate = delegate;
    }

    static <K, V> DelegatingCache<K, V> create(Ehcache delegate, CacheSettings settings) {
        return new DelegatingCache<K, V>(delegate, settings);
    }

    public boolean containsKey(@NotNull K key) {
        return this.delegate.isKeyInCache(key);
    }

    public Collection<K> getKeys() {
        try {
            return this.delegate.getKeys();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(K key, V value) {
        try {
            this.delegate.put(new Element(key, value));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V get(K key) {
        try {
            Element element = this.delegate.get(key);
            return (V)(element == null ? null : element.getObjectValue());
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void remove(K key) {
        try {
            this.delegate.remove(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void removeAll() {
        try {
            this.delegate.removeAll();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        this.removeAll();
    }

    public V putIfAbsent(K key, V value) {
        try {
            Element previous = this.delegate.putIfAbsent(new Element(key, value));
            if (previous != null) {
                return (V)previous.getObjectValue();
            }
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean remove(K key, V value) {
        try {
            return this.delegate.removeElement(new Element(key, value));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        try {
            return this.delegate.replace(new Element(key, oldValue), new Element(key, newValue));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof DelegatingCache) {
            DelegatingCache otherDelegatingCache = (DelegatingCache)other;
            if (this.delegate.equals(otherDelegatingCache.delegate)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.delegate.hashCode();
    }
}

