/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat;

import com.atlassian.annotations.PublicApi;
import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.cache.compat.memory.MemoryCacheFactory;
import com.atlassian.util.concurrent.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class CompatibilityCacheFactory
implements CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilityCacheFactory.class);
    private static final String CACHE_SETTINGS_CLASS = "com.atlassian.cache.CacheSettings";
    private static final String DELEGATING_CACHE_MANAGER_CLASS = "com.atlassian.cache.compat.delegate.DelegatingCacheFactory";
    private final CacheFactory delegate = this.isAtlassianCache2xAvailable() ? this.getDelegatingCacheFactory() : new MemoryCacheFactory();

    public <V> CachedReference<V> getCachedReference(@NotNull String name, @NotNull Supplier<V> supplier) {
        return this.delegate.getCachedReference(name, supplier);
    }

    public <V> CachedReference<V> getCachedReference(@NotNull String name, @NotNull Supplier<V> supplier, @NotNull CacheSettings required) {
        return this.delegate.getCachedReference(name, supplier, required);
    }

    public <V> CachedReference<V> getCachedReference(@NotNull Class<?> owningClass, @NotNull String name, @NotNull Supplier<V> supplier) {
        return this.delegate.getCachedReference(owningClass, name, supplier);
    }

    public <V> CachedReference<V> getCachedReference(@NotNull Class<?> owningClass, @NotNull String name, @NotNull Supplier<V> supplier, @NotNull CacheSettings required) {
        return this.delegate.getCachedReference(owningClass, name, supplier, required);
    }

    public <K, V> Cache<K, V> getCache(@NotNull String name) {
        return this.delegate.getCache(name);
    }

    public <K, V> Cache<K, V> getCache(@NotNull Class<?> owningClass, @NotNull String name) {
        return this.delegate.getCache(owningClass, name);
    }

    public <K, V> Cache<K, V> getCache(@NotNull String name, CacheLoader<K, V> loader) {
        return this.delegate.getCache(name, loader);
    }

    public <K, V> Cache<K, V> getCache(@NotNull String name, CacheLoader<K, V> loader, @NotNull CacheSettings required) {
        return this.delegate.getCache(name, loader, required);
    }

    @Deprecated
    public <K, V> Cache<K, V> getCache(@NotNull String name, @NotNull Class<K> keyType, @NotNull Class<V> valueType) {
        return this.delegate.getCache(name, keyType, valueType);
    }

    CacheFactory getDelegate() {
        return this.delegate;
    }

    CacheFactory getDelegatingCacheFactory() {
        try {
            return (CacheFactory)this.getClass().getClassLoader().loadClass(DELEGATING_CACHE_MANAGER_CLASS).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpectedly failed to initialize delegation to atlassian-cache-api", e);
        }
        catch (LinkageError e) {
            throw new IllegalStateException("An unexpected binary incompatibility prevented delegation to atlassian-cache-api", e);
        }
    }

    boolean isAtlassianCache2xAvailable() {
        try {
            this.getClass().getClassLoader().loadClass(CACHE_SETTINGS_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("ClassLoader is not a defined class; using non-cluster-safe implementation", (Throwable)e);
            return false;
        }
    }
}

