/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.impl;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class AbstractCacheFactory
implements CacheFactory {
    protected final ConcurrentMap<String, Supplier<Cache>> caches = new ConcurrentHashMap<String, Supplier<Cache>>();
    protected final Function<String, ManagedLock> cacheCreationLocks = ManagedLocks.weakManagedLockFactory();

    @Override
    public <K, V> Cache<K, V> getCache(@Nonnull String name) {
        return this.getCache(name, null);
    }

    @Override
    public <K, V> Cache<K, V> getCache(Class<?> owningClass, String name) {
        return this.getCache(AbstractCacheFactory.cacheName(owningClass, name));
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) {
        return this.getCache(name);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, CacheLoader<K, V> loader) {
        return this.getCache(name, loader, new CacheSettingsBuilder().build());
    }

    @Override
    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier) {
        return this.getCachedReference(name, supplier, new CacheSettingsBuilder().build());
    }

    @Override
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        return this.getCachedReference(owningClass, name, supplier, new CacheSettingsBuilder().build());
    }

    @Override
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings settings) {
        return this.getCachedReference(AbstractCacheFactory.cacheName(owningClass, name), supplier, settings);
    }

    private static String cacheName(Class<?> owningClass, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return owningClass.getName() + "." + name;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        if (null == loader) {
            return this.createSimpleCache(name, settings);
        }
        return this.createComputingCache(name, settings, loader);
    }

    protected abstract <K, V> Cache<K, V> createComputingCache(String var1, CacheSettings var2, CacheLoader<K, V> var3);

    protected abstract <K, V> Cache<K, V> createSimpleCache(String var1, CacheSettings var2);
}

