package com.atlassian.cache.impl.jmx;

import javax.annotation.Nullable;
import javax.management.MBeanServer;

/**
 * Provides operations for managing registration of JMX MBeans
 *
 * @since v2.0.11
 */
@SuppressWarnings("UnusedDeclaration")
public interface MBeanRegistrar
{
    /**
     * Tells this object to register its JMX MBeans with the given server.
     * What beans are registered, if any, is up to the implementation.
     *
     * @param mBeanServer the server with which to register the MBeans (ignored if null)
     * @since 2.0.11
     */
    void registerMBeans(@Nullable MBeanServer mBeanServer);

    /**
     * Tells this object to deregister its JMX MBeans from the given server.
     * All previously registered beans should be deregistered.
     *
     * @param mBeanServer the server with which to deregister the MBeans (ignored if null)
     * @since 2.4.0
     */
    void unregisterMBeans(@Nullable MBeanServer mBeanServer);
}
