package com.atlassian.cache.impl;

import java.util.function.Supplier;

/**
 * A supplier that holds a strong reference to its referent.
 * Contrast with {@link WeakSupplier}
 *
 * @since v2.0.8
 */
public class StrongSupplier<V> implements Supplier<V>
{
    private final V referent;

    public StrongSupplier(final V referent)
    {
        this.referent = referent;
    }

    public V get()
    {
        return referent;
    }
}
