/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache;

import com.atlassian.annotations.PublicApi;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.DefaultCacheSettings;
import com.atlassian.util.concurrent.NotNull;
import java.util.concurrent.TimeUnit;

@PublicApi
public class CacheSettingsBuilder {
    private Long expireAfterAccess;
    private Long expireAfterWrite;
    private Boolean flushable;
    private Boolean local;
    private Integer maxEntries;
    private Boolean replicateAsynchronously;
    private Boolean replicateViaCopy;

    public CacheSettings build() {
        return new DefaultCacheSettings(this.expireAfterAccess, this.expireAfterWrite, this.flushable, this.local, this.maxEntries, this.replicateAsynchronously, this.replicateViaCopy);
    }

    public CacheSettingsBuilder expireAfterAccess(long expireAfter, @NotNull TimeUnit timeUnit) {
        this.expireAfterAccess = timeUnit.toMillis(expireAfter);
        return this;
    }

    public CacheSettingsBuilder expireAfterWrite(long expireAfter, @NotNull TimeUnit timeUnit) {
        this.expireAfterWrite = timeUnit.toMillis(expireAfter);
        return this;
    }

    public CacheSettingsBuilder flushable() {
        this.flushable = true;
        return this;
    }

    public CacheSettingsBuilder unflushable() {
        this.flushable = false;
        return this;
    }

    public CacheSettingsBuilder maxEntries(int maxEntries) {
        if (0 >= maxEntries) {
            throw new IllegalArgumentException("maxEntries must be greater than zero, passed: " + maxEntries);
        }
        this.maxEntries = maxEntries;
        return this;
    }

    public CacheSettingsBuilder replicateAsynchronously() {
        this.replicateAsynchronously = true;
        return this;
    }

    public CacheSettingsBuilder replicateSynchronously() {
        this.replicateAsynchronously = false;
        return this;
    }

    public CacheSettingsBuilder replicateViaCopy() {
        this.replicateViaCopy = true;
        return this;
    }

    public CacheSettingsBuilder replicateViaInvalidation() {
        this.replicateViaCopy = false;
        return this;
    }

    public CacheSettingsBuilder local() {
        this.local = true;
        return this;
    }

    public CacheSettingsBuilder remote() {
        this.local = false;
        return this;
    }
}

