package com.atlassian.cache;

import java.util.Collection;

public interface Cache
{
    /**
     * The name of the cache, uniquely identifies this cache.
     * 
     * @return the name of the cache.
     */
    String getName();

    /**
     * Gets the keys of all objects currently stored in the cache. This will return the keys in a new collection.
     * @return a collection of {@link Object}s keys.
     */
    Collection getKeys();

    /**
     * Retrieve an object from this cache.
     * 
     * @param key uniquely identifying the object to be retrieved.
     * @return the object from the cache, or <code>null</code> if the object is not found.
     */
    Object get(final Object key);

    /**
     * Put an object into the cache. If the specified key already exists within the cache, it will be replaced by the
     * new object.
     * 
     * @param key uniquely identifying the object to be added into the cache.
     * @param value to be cached.
     */
    void put(final Object key, final Object value);

    /**
     * Remove the object identified by the key from the cache. If no object can be found associated with this key then
     * no action is taken.
     * 
     * @param key uniquely identifying the object to be removed.
     */
    void remove(final Object key);

    /**
     * Remove all of the objects from this cache.
     */
    void removeAll();
}