/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.JsonTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.vars.VariableMap;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class InstanceValidator
implements Processor<FullData, FullData> {
    private final MessageBundle syntaxMessages;
    private final MessageBundle validationMessages;
    private final Processor<SchemaContext, ValidatorList> keywordBuilder;
    private final Set<Equivalence.Wrapper<FullData>> visited = Sets.newLinkedHashSet();
    @ParametersAreNonnullByDefault
    private static final Equivalence<FullData> FULL_DATA_EQUIVALENCE = new Equivalence<FullData>(){

        @Override
        protected boolean doEquivalent(FullData a, FullData b) {
            JsonPointer ptra = a.getInstance().getPointer();
            JsonPointer ptrb = b.getInstance().getPointer();
            return a.getSchema().equals(b.getSchema()) && ptra.equals(ptrb);
        }

        @Override
        protected int doHash(FullData t) {
            return t.getSchema().hashCode() ^ t.getInstance().getPointer().hashCode();
        }
    };

    public InstanceValidator(MessageBundle syntaxMessages, MessageBundle validationMessages, Processor<SchemaContext, ValidatorList> keywordBuilder) {
        this.syntaxMessages = syntaxMessages;
        this.validationMessages = validationMessages;
        this.keywordBuilder = keywordBuilder;
    }

    @Override
    public FullData process(ProcessingReport report, FullData input) throws ProcessingException {
        if (!this.visited.add(FULL_DATA_EQUIVALENCE.wrap(input))) {
            throw new ProcessingException(this.validationLoopMessage(input));
        }
        SchemaContext context = new SchemaContext(input);
        ValidatorList fullContext = this.keywordBuilder.process(report, context);
        if (fullContext == null) {
            ProcessingMessage message = this.collectSyntaxErrors(report);
            throw new InvalidSchemaException(message);
        }
        SchemaContext newContext = fullContext.getContext();
        FullData data = new FullData(newContext.getSchema(), input.getInstance(), input.isDeepCheck());
        for (KeywordValidator validator : fullContext) {
            validator.validate(this, report, this.validationMessages, data);
        }
        if (!report.isSuccess() && !data.isDeepCheck()) {
            return input;
        }
        JsonNode node = data.getInstance().getNode();
        if (node.size() == 0) {
            return input;
        }
        if (node.isArray()) {
            this.processArray(report, data);
        } else {
            this.processObject(report, data);
        }
        return input;
    }

    public String toString() {
        return "instance validator";
    }

    private void processArray(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = new ArraySchemaSelector(digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.of(index, new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = new ObjectSchemaSelector(digest);
        ArrayList<String> fields = Lists.newArrayList(node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.of(field, new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private ProcessingMessage validationLoopMessage(FullData input) {
        String errmsg = this.validationMessages.getMessage("err.common.validationLoop");
        ArrayNode node = JacksonUtils.nodeFactory().arrayNode();
        for (Equivalence.Wrapper<FullData> e : this.visited) {
            node.add(InstanceValidator.toJson(e.get()));
        }
        return input.newMessage().put("domain", "validation").setMessage(errmsg).putArgument("alreadyVisited", InstanceValidator.toJson(input)).putArgument("instancePointer", input.getInstance().getPointer().toString()).put("validationPath", node);
    }

    private ProcessingMessage collectSyntaxErrors(ProcessingReport report) {
        String msg = this.syntaxMessages.getMessage("core.invalidSchema");
        ArrayNode arrayNode = JacksonUtils.nodeFactory().arrayNode();
        for (ProcessingMessage message : report) {
            JsonNode node = message.asJson();
            if (!"syntax".equals(node.path("domain").asText())) continue;
            arrayNode.add(node);
        }
        StringBuilder sb = new StringBuilder(msg);
        sb.append("\nSyntax errors:\n");
        sb.append(JacksonUtils.prettyPrint(arrayNode));
        return new ProcessingMessage().setMessage(sb.toString());
    }

    private static String toJson(FullData data) {
        URITemplate template;
        SchemaTree tree = data.getSchema();
        URI baseUri = tree.getLoadingRef().getLocator();
        VariableMap vars = VariableMap.newBuilder().addScalarValue("ptr", tree.getPointer()).freeze();
        try {
            template = new URITemplate(baseUri + "{+ptr}");
        }
        catch (URITemplateParseException e) {
            throw new IllegalStateException("wtf??", e);
        }
        try {
            return template.toString(vars);
        }
        catch (URITemplateException e) {
            throw new IllegalStateException("wtf??", e);
        }
    }
}

