/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.document.FieldOperation;
import com.atlassian.braid.document.MappedOperations;
import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.document.OperationMappingResult;
import com.atlassian.braid.document.SelectionSetMappingResult;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.java.util.BraidObjects;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.Selection;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TypedDocumentMapper
implements DocumentMapper {
    private final TypeDefinitionRegistry schema;
    private final List<TypeMapper> typeMappers;

    TypedDocumentMapper(TypeDefinitionRegistry schema, List<TypeMapper> typeMappers) {
        this.schema = Objects.requireNonNull(schema);
        this.typeMappers = Objects.requireNonNull(typeMappers);
    }

    @Override
    public DocumentMapper.MappedDocument apply(Document input) {
        return TypedDocumentMapper.getOperationDefinitionStream(input).map(this::mapOperation).collect(MappedOperations.toMappedDocument());
    }

    private OperationMappingResult mapOperation(OperationDefinition operationDefinition) {
        ObjectTypeDefinition operationTypeDefinition = TypedDocumentMapper.findOperationTypeDefinition(this.schema, operationDefinition);
        Map<Boolean, List<Selection>> fieldsAndNonFields = TypedDocumentMapper.getFieldsAndNonFields(operationDefinition);
        List<Selection> nonFields = fieldsAndNonFields.getOrDefault(false, Collections.emptyList());
        List fields = (List)BraidObjects.cast(fieldsAndNonFields.getOrDefault(true, Collections.emptyList()));
        return fields.stream().map(field -> this.toMappingContext(operationTypeDefinition, (Field)field)).map(TypedDocumentMapper::mapNode).collect(OperationMappingResult.toOperationMappingResult(operationDefinition, nonFields));
    }

    private MappingContext toMappingContext(ObjectTypeDefinition parentObjectType, Field field) {
        return MappingContext.of(this.schema, this.typeMappers, parentObjectType, field);
    }

    static FieldOperation.FieldOperationResult mapNode(MappingContext mappingContext) {
        ObjectTypeDefinition definition = mappingContext.getObjectTypeDefinition();
        Field field = mappingContext.getField();
        return mappingContext.getTypeMappers().stream().filter(typeMapper -> typeMapper.test(definition)).findFirst().map(typeMapper -> (SelectionSetMappingResult)typeMapper.apply(mappingContext, field.getSelectionSet())).map(mappingResult -> mappingResult.toFieldOperationResult(mappingContext)).orElse(FieldOperation.result(field));
    }

    private static Stream<OperationDefinition> getOperationDefinitionStream(Document input) {
        return input.getDefinitions().stream().filter(d -> d instanceof OperationDefinition).map(OperationDefinition.class::cast);
    }

    private static ObjectTypeDefinition findOperationTypeDefinition(TypeDefinitionRegistry schema, OperationDefinition op) {
        return TypeUtils.findOperationDefinitions(schema).flatMap(TypedDocumentMapper.maybeFindOperationTypeDefinition(op)).map(OperationTypeDefinition::getType).flatMap(arg_0 -> ((TypeDefinitionRegistry)schema).getType(arg_0)).map(BraidObjects::cast).orElseThrow(IllegalStateException::new);
    }

    private static Function<List<OperationTypeDefinition>, Optional<OperationTypeDefinition>> maybeFindOperationTypeDefinition(OperationDefinition op) {
        return ops -> ops.stream().filter(TypedDocumentMapper.isOperationTypeDefinitionForOperationType(op)).findFirst();
    }

    private static Predicate<OperationTypeDefinition> isOperationTypeDefinitionForOperationType(OperationDefinition op) {
        return otd -> otd.getName().equalsIgnoreCase(op.getOperation().name());
    }

    private static Map<Boolean, List<Selection>> getFieldsAndNonFields(OperationDefinition operationDefinition) {
        return operationDefinition.getSelectionSet().getSelections().stream().collect(Collectors.groupingBy(s -> s instanceof Field));
    }
}

