/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.Fields;
import com.atlassian.braid.document.TypeMapper;
import graphql.language.Field;
import graphql.language.ObjectTypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MappingContext {
    private final TypeDefinitionRegistry schema;
    private final List<TypeMapper> typeMappers;
    private final Field field;
    private final Supplier<Optional<TypeInfo>> typeInfo;
    private final Supplier<Optional<ObjectTypeDefinition>> objectTypeDefinition;
    private final Supplier<List<String>> path;

    private MappingContext(TypeDefinitionRegistry schema, List<TypeMapper> typeMappers, List<String> parentPath, ObjectTypeDefinition parentObjectTypeDefinition, Field field) {
        this.schema = Objects.requireNonNull(schema);
        this.typeMappers = Objects.requireNonNull(typeMappers);
        this.field = Objects.requireNonNull(field);
        this.typeInfo = MappingContext.memoize(() -> Fields.maybeGetTypeInfo(parentObjectTypeDefinition, field));
        this.objectTypeDefinition = MappingContext.memoize(() -> Fields.maybeFindObjectTypeDefinition(schema, this.typeInfo.get()));
        this.path = MappingContext.memoize(() -> this.getTypeInfo().isList() ? Collections.emptyList() : MappingContext.appendToList(parentPath, Fields.getFieldAliasOrName(field)));
    }

    static MappingContext of(TypeDefinitionRegistry schema, List<TypeMapper> typeMappers, ObjectTypeDefinition definition, Field field) {
        return new MappingContext(schema, typeMappers, Collections.emptyList(), definition, field);
    }

    MappingContext to(Field field) {
        return new MappingContext(this.schema, this.typeMappers, this.getPath(), this.getObjectTypeDefinition(), field);
    }

    private List<String> getPath() {
        return this.path.get();
    }

    String getSpringPath(String targetKey) {
        return MappingContext.appendAsStream(this.getPath(), targetKey).map(p -> "['" + p + "']").collect(Collectors.joining());
    }

    List<TypeMapper> getTypeMappers() {
        return this.typeMappers;
    }

    public TypeDefinitionRegistry getSchema() {
        return this.schema;
    }

    Field getField() {
        return this.field;
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo.get().orElseThrow(IllegalStateException::new);
    }

    ObjectTypeDefinition getObjectTypeDefinition() {
        return this.objectTypeDefinition.get().orElseThrow(IllegalStateException::new);
    }

    private static <T> Supplier<T> memoize(Supplier<T> supplier) {
        return new MemoizingSupplier<T>(supplier);
    }

    private static <T> List<T> appendToList(List<T> list, T element) {
        return MappingContext.appendAsStream(list, element).collect(Collectors.toList());
    }

    private static <T> Stream<T> appendAsStream(List<T> list, T element) {
        return Stream.concat(list.stream(), Stream.of(element));
    }

    private static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;
        private static final long serialVersionUID = 0L;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            return "Suppliers.memoize(" + this.delegate + ")";
        }
    }
}

