/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Braid;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaBraidConfiguration;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;

public class SchemaBraid<C extends BraidContext> {
    @Deprecated
    public Braid braid(SchemaSource<C> ... dataSources) {
        return this.braid(new TypeDefinitionRegistry(), RuntimeWiring.newRuntimeWiring(), dataSources);
    }

    @Deprecated
    public Braid braid(TypeDefinitionRegistry allTypes, RuntimeWiring.Builder wiringBuilder, SchemaSource<C> ... dataSources) {
        SchemaBraidConfiguration.SchemaBraidConfigurationBuilder configBuilder = SchemaBraidConfiguration.builder().typeDefinitionRegistry(allTypes).runtimeWiringBuilder(wiringBuilder);
        Arrays.stream(dataSources).forEach(configBuilder::schemaSource);
        return this.braid(configBuilder.build());
    }

    public Braid braid(SchemaBraidConfiguration<C> config) {
        Map<SchemaNamespace, Source<C>> dataSourceTypes = SchemaBraid.collectDataSources(config);
        TypeDefinitionRegistry braidTypeRegistry = TypeUtils.createSchemaDefinitionIfNecessary(config.getTypeDefinitionRegistry());
        ObjectTypeDefinition queryObjectTypeDefinition = TypeUtils.findQueryType(braidTypeRegistry).orElseGet(() -> TypeUtils.createDefaultQueryTypeDefinition(braidTypeRegistry));
        ObjectTypeDefinition mutationObjectTypeDefinition = TypeUtils.findMutationType(braidTypeRegistry).orElseGet(() -> TypeUtils.createDefaultMutationTypeDefinition(braidTypeRegistry));
        RuntimeWiring.Builder wiringBuilder = config.getRuntimeWiringBuilder();
        Map<String, BatchLoader> batchLoaders = this.addDataSources(dataSourceTypes, braidTypeRegistry, wiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(braidTypeRegistry, wiringBuilder.build());
        return new Braid(graphQLSchema, batchLoaders);
    }

    private Map<String, BatchLoader> addDataSources(Map<SchemaNamespace, Source<C>> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition) {
        this.addAllNonOperationTypes(dataSources, registry);
        List<FieldDataLoaderRegistration> linkedTypesBatchLoaders = this.linkTypes(dataSources, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        List<FieldDataLoaderRegistration> queryFieldsBatchLoaders = this.addSchemaSourcesTopLevelFieldsToOperation(dataSources, queryObjectTypeDefinition, Source::getQueryType);
        List<FieldDataLoaderRegistration> mutationFieldsBatchLoaders = this.addSchemaSourcesTopLevelFieldsToOperation(dataSources, mutationObjectTypeDefinition, Source::getMutationType);
        HashMap<String, BatchLoader> loaders = new HashMap<String, BatchLoader>();
        Stream.concat(linkedTypesBatchLoaders.stream(), Stream.concat(queryFieldsBatchLoaders.stream(), mutationFieldsBatchLoaders.stream())).forEach(r -> {
            String key = SchemaBraid.getDataLoaderKey(((FieldDataLoaderRegistration)r).type, ((FieldDataLoaderRegistration)r).field);
            BatchLoader linkBatchLoader = (BatchLoader)loaders.get(key);
            if (linkBatchLoader != null) {
                loaders.put(key + "-link", linkBatchLoader);
            }
            runtimeWiringBuilder.type(((FieldDataLoaderRegistration)r).type, wiring -> wiring.dataFetcher(((FieldDataLoaderRegistration)r).field, (DataFetcher)new BraidDataFetcher(key)));
            loaders.put(key, ((FieldDataLoaderRegistration)r).loader);
        });
        return loaders;
    }

    private void addAllNonOperationTypes(Map<SchemaNamespace, Source<C>> dataSources, TypeDefinitionRegistry registry) {
        dataSources.values().forEach(source -> source.getNonOperationTypes().forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0)));
    }

    private List<FieldDataLoaderRegistration> addSchemaSourcesTopLevelFieldsToOperation(Map<SchemaNamespace, Source<C>> dataSources, ObjectTypeDefinition braidOperationType, Function<Source<C>, Optional<ObjectTypeDefinition>> findOperationType) {
        return dataSources.values().stream().map(source -> this.addSchemaSourceTopLevelFieldsToOperation((Source<C>)source, braidOperationType, findOperationType)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(Source<C> source, ObjectTypeDefinition braidMutationType, Function<Source<C>, Optional<ObjectTypeDefinition>> findOperationType) {
        return findOperationType.apply(source).map(operationType -> this.addSchemaSourceTopLevelFieldsToOperation(((Source)source).schemaSource, braidMutationType, (ObjectTypeDefinition)operationType)).orElse(Collections.emptyList());
    }

    private List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(SchemaSource<C> schemaSource, ObjectTypeDefinition braidOperationType, ObjectTypeDefinition sourceOperationType) {
        braidOperationType.getFieldDefinitions().addAll(sourceOperationType.getFieldDefinitions());
        return SchemaBraid.wireOperationFields(braidOperationType.getName(), schemaSource, sourceOperationType);
    }

    private static <C extends BraidContext> List<FieldDataLoaderRegistration> wireOperationFields(String typeName, SchemaSource<C> schemaSource, ObjectTypeDefinition sourceOperationType) {
        return sourceOperationType.getFieldDefinitions().stream().map(queryField -> SchemaBraid.wireOperationField(typeName, schemaSource, queryField)).collect(Collectors.toList());
    }

    private static <C extends BraidContext> FieldDataLoaderRegistration wireOperationField(String typeName, SchemaSource<C> schemaSource, FieldDefinition mutationField) {
        BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = SchemaBraid.newBatchLoader(schemaSource, null);
        return new FieldDataLoaderRegistration(typeName, mutationField.getName(), batchLoader);
    }

    private List<FieldDataLoaderRegistration> linkTypes(Map<SchemaNamespace, Source<C>> sources, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition) {
        ArrayList<FieldDataLoaderRegistration> fieldDataLoaderRegistrations = new ArrayList<FieldDataLoaderRegistration>();
        for (Source<C> source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = ((Source)source).registry;
            HashMap<String, TypeDefinition> dsTypes = new HashMap<String, TypeDefinition>(typeRegistry.types());
            for (Link link : ((Source)source).schemaSource.getLinks()) {
                Source<C> targetSource;
                ObjectTypeDefinition typeDefinition = this.getObjectTypeDefinition(queryObjectTypeDefinition, mutationObjectTypeDefinition, typeRegistry, dsTypes, link);
                this.validateSourceFromFieldExists(link, typeDefinition);
                Optional<FieldDefinition> sourceField = typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceField())).findFirst();
                Optional<FieldDefinition> sourceFromField = typeDefinition.getFieldDefinitions().stream().filter(s -> s != null && s.getName().equals(link.getSourceFromField())).findAny();
                if (link.isReplaceFromField()) {
                    typeDefinition.getFieldDefinitions().remove(sourceFromField.get());
                }
                if ((targetSource = sources.get(link.getTargetNamespace())) == null) {
                    throw new IllegalArgumentException("Can't find target schema source: " + link.getTargetNamespace());
                }
                if (!((Source)targetSource).registry.getType(link.getTargetType()).isPresent()) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                TypeName targetType = new TypeName(link.getTargetType());
                if (!sourceField.isPresent()) {
                    if (sourceFromField.isPresent() && this.isListType(sourceFromField.get().getType())) {
                        targetType = new ListType((Type)targetType);
                    }
                    FieldDefinition field = new FieldDefinition(link.getSourceField(), (Type)targetType);
                    typeDefinition.getFieldDefinitions().add(field);
                } else if (this.isListType(sourceField.get().getType())) {
                    if (sourceField.get().getType() instanceof NonNullType) {
                        sourceField.get().setType((Type)new NonNullType((Type)new ListType((Type)targetType)));
                    } else {
                        sourceField.get().setType((Type)new ListType((Type)targetType));
                    }
                } else {
                    sourceField.get().setType((Type)targetType);
                }
                BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = SchemaBraid.newBatchLoader(((Source)targetSource).schemaSource, link);
                fieldDataLoaderRegistrations.add(new FieldDataLoaderRegistration(link.getSourceType(), link.getSourceField(), batchLoader));
            }
        }
        return fieldDataLoaderRegistrations;
    }

    private boolean isListType(Type type) {
        return type instanceof ListType || type instanceof NonNullType && ((NonNullType)type).getType() instanceof ListType;
    }

    private ObjectTypeDefinition getObjectTypeDefinition(ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, TypeDefinitionRegistry typeRegistry, HashMap<String, TypeDefinition> dsTypes, Link link) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(link.getSourceType());
        if (typeDefinition == null && link.getSourceType().equals(queryObjectTypeDefinition.getName()) && (typeDefinition = (ObjectTypeDefinition)TypeUtils.findQueryType(typeRegistry).orElse(null)) == null && link.getSourceType().equals(mutationObjectTypeDefinition.getName())) {
            typeDefinition = TypeUtils.findMutationType(typeRegistry).orElse(null);
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Can't find source type: " + link.getSourceType());
        }
        return typeDefinition;
    }

    private static String getDataLoaderKey(String sourceType, String sourceField) {
        return sourceType + "." + sourceField;
    }

    private static <C extends BraidContext> BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource<C> schemaSource, Link link) {
        return schemaSource.newBatchLoader(schemaSource, link);
    }

    private void validateSourceFromFieldExists(Link link, ObjectTypeDefinition typeDefinition) {
        typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceFromField())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source from field: %s", link.getSourceFromField())));
    }

    private static <C extends BraidContext> Map<SchemaNamespace, Source<C>> collectDataSources(SchemaBraidConfiguration<C> config) {
        return config.getSchemaSources().stream().collect(Collectors.toMap(SchemaSource::getNamespace, x$0 -> new Source((SchemaSource)x$0)));
    }

    private static class FieldDataLoaderRegistration {
        private final String type;
        private final String field;
        private final BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader;

        private FieldDataLoaderRegistration(String type, String field, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader) {
            this.type = type;
            this.field = field;
            this.loader = loader;
        }
    }

    private static final class Source<C extends BraidContext> {
        private final SchemaSource<C> schemaSource;
        private final TypeDefinitionRegistry registry;
        private final ObjectTypeDefinition queryType;
        private final ObjectTypeDefinition mutationType;

        private Source(SchemaSource<C> schemaSource) {
            this.schemaSource = Objects.requireNonNull(schemaSource);
            this.registry = schemaSource.getSchema();
            this.queryType = TypeUtils.findQueryType(this.registry).orElse(null);
            this.mutationType = TypeUtils.findMutationType(this.registry).orElse(null);
        }

        Collection<? extends TypeDefinition> getNonOperationTypes() {
            return this.registry.types().values().stream().filter(this::isNotOperationType).collect(Collectors.toList());
        }

        public Optional<ObjectTypeDefinition> getQueryType() {
            return Optional.ofNullable(this.queryType);
        }

        public Optional<ObjectTypeDefinition> getMutationType() {
            return Optional.ofNullable(this.mutationType);
        }

        boolean isNotOperationType(TypeDefinition typeDefinition) {
            return !this.isOperationType(typeDefinition);
        }

        boolean isOperationType(TypeDefinition typeDefinition) {
            Objects.requireNonNull(typeDefinition);
            return Objects.equals(this.queryType, typeDefinition) || Objects.equals(this.mutationType, typeDefinition);
        }
    }

    private static class BraidDataFetcher
    implements DataFetcher {
        private final String dataLoaderKey;

        private BraidDataFetcher(String dataLoaderKey) {
            this.dataLoaderKey = Objects.requireNonNull(dataLoaderKey);
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoaderRegistry registry = BraidDataFetcher.getDataLoaderRegistry(env);
            CompletableFuture loadedValue = registry.getDataLoader(this.dataLoaderKey).load((Object)env);
            return Optional.ofNullable(registry.getDataLoader(this.dataLoaderKey + "-link")).map(l -> BraidDataFetcher.loadFromLinkLoader(env, loadedValue, (DataLoader<Object, Object>)l)).orElse(loadedValue);
        }

        private static Object loadFromLinkLoader(DataFetchingEnvironment env, Object source, DataLoader<Object, Object> dataLoader) {
            return dataLoader.load((Object)DataFetchingEnvironmentBuilder.newDataFetchingEnvironment((DataFetchingEnvironment)env).source(source).fieldDefinition(env.getFieldDefinition()).build());
        }

        private static DataLoaderRegistry getDataLoaderRegistry(DataFetchingEnvironment env) {
            return BraidDataFetcher.getContext(env).getDataLoaderRegistry();
        }

        private static BraidContext getContext(DataFetchingEnvironment env) {
            return (BraidContext)env.getContext();
        }
    }
}

