/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.document.DocumentMapperFactory;
import com.atlassian.braid.document.DocumentMappers;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.BaseQueryExecutorSchemaSource;
import com.atlassian.braid.source.ForwardingSchemaSource;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.SchemaUtils;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public final class LocalQueryExecutingSchemaSource<C extends BraidContext>
extends ForwardingSchemaSource<C>
implements QueryExecutorSchemaSource<C> {
    private final BaseQueryExecutorSchemaSource<C> delegate;
    private final Function<ExecutionInput, Object> queryExecutor;

    public LocalQueryExecutingSchemaSource(SchemaNamespace namespace, Supplier<Reader> schemaProvider, Function<ExecutionInput, Object> queryExecutor) {
        this(namespace, schemaProvider, Collections.emptyList(), DocumentMappers.identity(), queryExecutor);
    }

    public LocalQueryExecutingSchemaSource(SchemaNamespace namespace, Supplier<Reader> schemaProvider, List<Link> links, DocumentMapperFactory documentMapper, Function<ExecutionInput, Object> queryExecutor) {
        this(namespace, SchemaUtils.loadSchema(schemaProvider), links, documentMapper, queryExecutor);
    }

    public LocalQueryExecutingSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, List<Link> links, DocumentMapperFactory documentMapper, Function<ExecutionInput, Object> queryExecutor) {
        this.queryExecutor = Objects.requireNonNull(queryExecutor);
        this.delegate = new BaseQueryExecutorSchemaSource<BraidContext>(namespace, schema, links, documentMapper, this::query);
    }

    @Override
    protected SchemaSource<C> getDelegate() {
        return this.delegate;
    }

    @Override
    public DocumentMapper getDocumentMapper() {
        return this.delegate.getDocumentMapper();
    }

    private CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput executionInput, C context) {
        Object result = this.queryExecutor.apply(this.transformExecutionInput(executionInput, context));
        if (result instanceof DataFetcherResult) {
            return CompletableFuture.completedFuture(BraidObjects.cast(result));
        }
        if (result instanceof Map) {
            return CompletableFuture.completedFuture(new DataFetcherResult(BraidObjects.cast(result), Collections.emptyList()));
        }
        CompletableFuture<DataFetcherResult<Map<String, Object>>> future = new CompletableFuture<DataFetcherResult<Map<String, Object>>>();
        future.completeExceptionally(new IllegalStateException("Unexpected result type: " + LocalQueryExecutingSchemaSource.nullSafeGetClass(result)));
        return future;
    }

    private ExecutionInput transformExecutionInput(ExecutionInput executionInput, C context) {
        return executionInput.transform(builder -> builder.context(context));
    }

    private static Class<?> nullSafeGetClass(Object result) {
        return Optional.ofNullable(result).map(Object::getClass).orElse(null);
    }
}

