/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BatchLoaderFactory;
import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.GraphQLQueryVisitor;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.GraphQLNodes;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.source.DocumentCloners;
import com.atlassian.braid.source.QueryFunction;
import com.atlassian.braid.source.RelativeGraphQLError;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.Parser;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

class QueryExecutor<C extends BraidContext>
implements BatchLoaderFactory<C> {
    private final QueryFunction<C> queryFunction;

    QueryExecutor(QueryFunction<C> queryFunction) {
        this.queryFunction = Objects.requireNonNull(queryFunction);
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> newBatchLoader(SchemaSource<C> schemaSource, Link link) {
        return environments -> this.query(schemaSource, environments, link);
    }

    CompletableFuture<List<DataFetcherResult<Map<String, Object>>>> query(SchemaSource<C> schemaSource, List<DataFetchingEnvironment> environments, Link link) {
        CompletableFuture<DataFetcherResult> queryResult;
        DataFetchingEnvironment firstEnv = (DataFetchingEnvironment)environments.stream().findFirst().orElseThrow(IllegalStateException::new);
        GraphQLOutputType fieldType = firstEnv.getFieldDefinition().getType();
        Document doc = new Document();
        OperationDefinition.Operation operationType = this.getOperationType(firstEnv).orElse(OperationDefinition.Operation.QUERY);
        OperationDefinition queryOp = this.newQueryOperationDefinition(fieldType, operationType);
        doc.getDefinitions().add(queryOp);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        HashMap<DataFetchingEnvironment, Field> clonedFields = new HashMap<DataFetchingEnvironment, Field>();
        int counter = 99;
        for (DataFetchingEnvironment environment : environments) {
            Field field = this.cloneCurrentField(environment);
            field.setAlias(field.getName() + ++counter);
            clonedFields.put(environment, field);
            this.trimFieldSelection(schemaSource, environment, field);
            if (link != null) {
                String varName = link.getArgumentName() + counter;
                field.setArguments(Collections.singletonList(new Argument(link.getArgumentName(), (Value)new VariableReference(varName))));
                field.setName(link.getTargetField());
                String targetId = BatchLoaderUtils.getTargetIdFromEnvironment(link, environment);
                if (targetId == null && !link.isNullable()) continue;
                Type argumentType = this.findArgumentType(schemaSource, link);
                variables.put(varName, targetId);
                queryOp.getVariableDefinitions().add(new VariableDefinition(varName, argumentType));
            }
            Document queryDoc = new Parser().parseDocument(((BraidContext)environment.getContext()).getQuery());
            OperationDefinition operationDefinition = QueryExecutor.findSingleOperationDefinition(queryDoc);
            VariableNamespacingGraphQLQueryVisitor variableNameSpacer = new VariableNamespacingGraphQLQueryVisitor(counter, operationDefinition, variables, environment, queryOp);
            this.processForFragments(environment, field).forEach(d -> {
                variableNameSpacer.visit((Node)d);
                doc.getDefinitions().add(d);
            });
            variableNameSpacer.visit((Node)field);
            queryOp.getSelectionSet().getSelections().add(field);
        }
        if (queryOp.getSelectionSet().getSelections().isEmpty()) {
            queryResult = CompletableFuture.completedFuture(new DataFetcherResult(Collections.emptyMap(), Collections.emptyList()));
        } else {
            ExecutionInput input = this.executeBatchQuery(doc, queryOp.getName(), variables);
            queryResult = this.queryFunction.query(input, (BraidContext)environments.get(0).getContext());
        }
        return queryResult.thenApply(result -> this.transformBatchResultIntoResultList(environments, clonedFields, (DataFetcherResult<Map<String, Object>>)result));
    }

    private OperationDefinition newQueryOperationDefinition(GraphQLOutputType fieldType, OperationDefinition.Operation operationType) {
        return new OperationDefinition(this.newBulkOperationName(fieldType), operationType, new SelectionSet());
    }

    private Optional<OperationDefinition.Operation> getOperationType(DataFetchingEnvironment env) {
        GraphQLType graphQLType = env.getParentType();
        GraphQLSchema graphQLSchema = env.getGraphQLSchema();
        if (Objects.equals(graphQLSchema.getQueryType(), graphQLType)) {
            return Optional.of(OperationDefinition.Operation.QUERY);
        }
        if (Objects.equals(graphQLSchema.getMutationType(), graphQLType)) {
            return Optional.of(OperationDefinition.Operation.MUTATION);
        }
        return Optional.empty();
    }

    private String newBulkOperationName(GraphQLOutputType fieldType) {
        return "Bulk_" + fieldType.getName();
    }

    private Field cloneCurrentField(DataFetchingEnvironment environment) {
        Field original = this.findFieldWithName(environment);
        return DocumentCloners.clone(original);
    }

    private ExecutionInput executeBatchQuery(Document doc, String operationName, Map<String, Object> variables) {
        return ExecutionInput.newExecutionInput().query(GraphQLNodes.printNode((Node)doc)).operationName(operationName).variables(variables).build();
    }

    private List<DataFetcherResult<Map<String, Object>>> transformBatchResultIntoResultList(List<DataFetchingEnvironment> environments, Map<DataFetchingEnvironment, Field> clonedFields, DataFetcherResult<Map<String, Object>> result) {
        ArrayList<DataFetcherResult<Map<String, Object>>> queryResults = new ArrayList<DataFetcherResult<Map<String, Object>>>();
        Map data = (Map)result.getData();
        for (DataFetchingEnvironment environment : environments) {
            Field field = clonedFields.get(environment);
            Map fieldData = data.getOrDefault(field.getAlias(), null);
            queryResults.add((DataFetcherResult<Map<String, Object>>)new DataFetcherResult((Object)fieldData, result.getErrors().stream().filter(e -> e.getPath() == null || e.getPath().isEmpty() || field.getAlias().equals(e.getPath().get(0))).map(RelativeGraphQLError::new).collect(Collectors.toList())));
        }
        return queryResults;
    }

    private static OperationDefinition findSingleOperationDefinition(Document queryDoc) {
        return (OperationDefinition)queryDoc.getDefinitions().stream().filter(d -> d instanceof OperationDefinition).map(OperationDefinition.class::cast).collect(BraidCollectors.singleton());
    }

    private Type findArgumentType(SchemaSource<C> schemaSource, Link link) {
        return TypeUtils.findQueryFieldDefinitions(schemaSource.getPrivateSchema()).orElseThrow(IllegalStateException::new).stream().filter(f -> f.getName().equals(link.getTargetField())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getArgumentName())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }

    private Field findFieldWithName(DataFetchingEnvironment environment) {
        return environment.getFields().stream().filter(f -> environment.getFieldDefinition().getName().equals(f.getName())).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    void trimFieldSelection(final SchemaSource<C> schemaSource, final DataFetchingEnvironment environment, final Field field) {
        new GraphQLQueryVisitor(){
            GraphQLOutputType parentType = null;
            GraphQLOutputType lastFieldType = null;

            @Override
            protected void visitField(Field node) {
                GraphQLOutputType type;
                if (node == field) {
                    type = environment.getFieldType();
                } else {
                    QueryExecutor.this.getLink(schemaSource.getLinks(), this.parentType.getName(), node.getName()).ifPresent(l -> node.setSelectionSet(null));
                    type = Introspection.TypeNameMetaFieldDef.getName().equals(node.getName()) ? Introspection.TypeNameMetaFieldDef.getType() : (this.parentType instanceof GraphQLInterfaceType ? ((GraphQLInterfaceType)this.parentType).getFieldDefinition(node.getName()).getType() : ((GraphQLObjectType)this.parentType).getFieldDefinition(node.getName()).getType());
                }
                while (type instanceof GraphQLModifiedType) {
                    type = ((GraphQLModifiedType)type).getWrappedType();
                }
                this.lastFieldType = type;
                super.visitField(node);
            }

            @Override
            protected void visitSelectionSet(SelectionSet node) {
                if (node == null) {
                    return;
                }
                if (!node.getChildren().isEmpty()) {
                    GraphQLOutputType lastParentType = this.parentType;
                    this.parentType = this.lastFieldType;
                    for (Node child : node.getChildren()) {
                        Optional linkWithDifferentFromField;
                        if (child instanceof Field && (linkWithDifferentFromField = QueryExecutor.this.getLinkWithDifferentFromField(schemaSource.getLinks(), this.parentType.getName(), ((Field)child).getName())).isPresent()) {
                            this.removeSourceFieldIfDifferentThanFromField(node, (Link)linkWithDifferentFromField.get());
                            this.addFromFieldToQueryIfMissing(node, (Link)linkWithDifferentFromField.get());
                        }
                        this.visit(child);
                    }
                    this.parentType = lastParentType;
                }
            }

            private void addFromFieldToQueryIfMissing(SelectionSet node, Link link) {
                Optional<Selection> fromField = node.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceFromField())).findFirst();
                if (!fromField.isPresent()) {
                    node.getSelections().add(new Field(link.getSourceFromField()));
                }
            }

            private void removeSourceFieldIfDifferentThanFromField(SelectionSet node, Link link) {
                node.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceField())).findAny().ifPresent(s -> node.getSelections().remove(s));
            }
        }.visit((Node)field);
    }

    Collection<Definition> processForFragments(final DataFetchingEnvironment environment, Field field) {
        final HashMap result = new HashMap();
        new GraphQLQueryVisitor(){

            @Override
            protected void visitFragmentSpread(FragmentSpread node) {
                FragmentDefinition fragmentDefinition = (FragmentDefinition)environment.getFragmentsByName().get(node.getName());
                result.put(node.getName(), fragmentDefinition.deepCopy());
                super.visitFragmentSpread(node);
            }
        }.visit((Node)field);
        return result.values();
    }

    private Optional<Link> getLink(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private Optional<Link> getLinkWithDifferentFromField(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceField().equals(fieldName) && !l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private static class VariableNamespacingGraphQLQueryVisitor
    extends GraphQLQueryVisitor {
        private final int counter;
        private final OperationDefinition queryType;
        private final Map<String, Object> variables;
        private final DataFetchingEnvironment environment;
        private final OperationDefinition queryOp;

        VariableNamespacingGraphQLQueryVisitor(int counter, OperationDefinition operationDefinition, Map<String, Object> variables, DataFetchingEnvironment environment, OperationDefinition queryOp) {
            this.counter = counter;
            this.queryType = operationDefinition;
            this.variables = variables;
            this.environment = environment;
            this.queryOp = queryOp;
        }

        @Override
        protected void visitField(Field node) {
            node.setArguments(node.getArguments().stream().map(this::namespaceReferences).collect(Collectors.toList()));
            super.visitField(node);
        }

        private Argument namespaceReferences(Argument arg) {
            return new Argument(arg.getName(), this.namespaceReferences(arg.getValue()));
        }

        private Value namespaceReferences(Value value) {
            Object transformedValue = value instanceof VariableReference ? this.maybeNamespaceReference((VariableReference)value) : (value instanceof ObjectValue ? this.namespaceReferencesForObjectValue((ObjectValue)value) : value);
            return transformedValue;
        }

        private ObjectValue namespaceReferencesForObjectValue(ObjectValue value) {
            return new ObjectValue(value.getChildren().stream().map(ObjectField.class::cast).map(o -> new ObjectField(o.getName(), this.namespaceReferences(o.getValue()))).collect(Collectors.toList()));
        }

        private VariableReference maybeNamespaceReference(VariableReference value) {
            return this.isVariableAlreadyNamespaced(value) ? value : this.namespaceVariable(value);
        }

        private VariableReference namespaceVariable(VariableReference varRef) {
            String newName = varRef.getName() + this.counter;
            VariableReference value = new VariableReference(newName);
            Type type = VariableNamespacingGraphQLQueryVisitor.findVariableType(varRef, this.queryType);
            this.variables.put(newName, ((BraidContext)this.environment.getContext()).getVariables().get(varRef.getName()));
            this.queryOp.getVariableDefinitions().add(new VariableDefinition(newName, type));
            return value;
        }

        private boolean isVariableAlreadyNamespaced(VariableReference varRef) {
            return varRef.getName().endsWith(String.valueOf(this.counter));
        }

        private static Type findVariableType(VariableReference varRef, OperationDefinition queryType) {
            return queryType.getVariableDefinitions().stream().filter(d -> d.getName().equals(varRef.getName())).map(VariableDefinition::getType).findFirst().orElseThrow(IllegalArgumentException::new);
        }
    }
}

