/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.language;

import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import java.util.List;
import java.util.function.Consumer;

final class GraphQLQueryPrinter {
    private static final int INDENT_WIDTH = 4;

    GraphQLQueryPrinter() {
    }

    String print(Node node) {
        return new Printer(node).print();
    }

    private static class Printer {
        private final StringBuilder str = new StringBuilder();
        private final Node root;
        private int indentLevel = 0;

        Printer(Node root) {
            this.root = root;
        }

        public String print() {
            this.print(this.root);
            return this.str.toString();
        }

        private <T extends Node> void join(List<T> nodes, String delimiter) {
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = (Node)nodes.get(i);
                this.print(node);
                if (i + 1 == size) continue;
                this.str.append(delimiter);
            }
        }

        private <T> void wrap(String start, T obj, String end) {
            this.wrap(start, obj, end, this.str::append);
        }

        private <T> void wrap(String start, T obj, String end, Consumer<T> inner) {
            if (obj instanceof List && ((List)obj).isEmpty()) {
                return;
            }
            this.str.append(start);
            inner.accept(obj);
            this.str.append(end);
        }

        private String getNewLine() {
            StringBuilder str = new StringBuilder();
            str.append("\n");
            for (int i = 0; i < this.indentLevel; ++i) {
                for (int j = 0; j < 4; ++j) {
                    str.append(" ");
                }
            }
            return str.toString();
        }

        private void line() {
            this.line(1);
        }

        private void line(int count) {
            for (int i = 0; i < count; ++i) {
                this.str.append(this.getNewLine());
            }
        }

        private void print(Node node) {
            if (node instanceof Document) {
                this.print((Document)node);
            } else if (node instanceof OperationDefinition) {
                this.print((OperationDefinition)node);
            } else if (node instanceof FragmentDefinition) {
                this.print((FragmentDefinition)node);
            } else if (node instanceof VariableDefinition) {
                this.print((VariableDefinition)node);
            } else if (node instanceof ArrayValue) {
                this.print((ArrayValue)node);
            } else if (node instanceof BooleanValue) {
                this.print((BooleanValue)node);
            } else if (node instanceof EnumValue) {
                this.print((EnumValue)node);
            } else if (node instanceof FloatValue) {
                this.print((FloatValue)node);
            } else if (node instanceof IntValue) {
                this.print((IntValue)node);
            } else if (node instanceof ObjectValue) {
                this.print((ObjectValue)node);
            } else if (node instanceof StringValue) {
                this.print((StringValue)node);
            } else if (node instanceof VariableReference) {
                this.print((VariableReference)node);
            } else if (node instanceof ListType) {
                this.print((ListType)node);
            } else if (node instanceof NonNullType) {
                this.print((NonNullType)node);
            } else if (node instanceof TypeName) {
                this.print((TypeName)node);
            } else if (node instanceof Directive) {
                this.print((Directive)node);
            } else if (node instanceof Argument) {
                this.print((Argument)node);
            } else if (node instanceof ObjectField) {
                this.print((ObjectField)node);
            } else if (node instanceof SelectionSet) {
                this.print((SelectionSet)node);
            } else if (node instanceof Field) {
                this.print((Field)node);
            } else if (node instanceof InlineFragment) {
                this.print((InlineFragment)node);
            } else if (node instanceof FragmentSpread) {
                this.print((FragmentSpread)node);
            } else {
                throw new RuntimeException("unknown type");
            }
        }

        private void print(Document node) {
            for (Definition defintition : node.getDefinitions()) {
                this.print((Node)defintition);
                this.line(2);
            }
            this.line();
        }

        private void print(OperationDefinition node) {
            String name = node.getName();
            OperationDefinition.Operation operation = node.getOperation();
            List variableDefinitions = node.getVariableDefinitions();
            List directives = node.getDirectives();
            SelectionSet selectionSet = node.getSelectionSet();
            if (name == null && variableDefinitions.isEmpty() && directives.isEmpty() && operation == OperationDefinition.Operation.QUERY) {
                this.print(selectionSet);
            } else {
                if (operation == OperationDefinition.Operation.QUERY) {
                    this.str.append("query ");
                } else if (operation == OperationDefinition.Operation.MUTATION) {
                    this.str.append("mutation ");
                } else {
                    throw new RuntimeException("unsupported operation");
                }
                if (name != null) {
                    this.str.append(name);
                }
                this.wrap("(", variableDefinitions, ")", definitions -> this.join((List)definitions, ", "));
                this.wrap(" ", directives, " ", dirs -> this.join((List)dirs, " "));
                this.str.append(" ");
                this.print(selectionSet);
            }
        }

        private void print(VariableDefinition node) {
            this.str.append("$");
            this.str.append(node.getName());
            this.str.append(": ");
            this.print((Node)node.getType());
            Value defaultValue = node.getDefaultValue();
            if (defaultValue != null) {
                this.str.append(" = ");
                this.print((Node)defaultValue);
            }
        }

        private void print(Directive node) {
            this.str.append("@");
            this.str.append(node.getName());
            this.wrap("(", node.getArguments(), ")", arguments -> this.join((List)arguments, ", "));
        }

        private void print(SelectionSet node) {
            this.print(node, false);
        }

        private void print(SelectionSet node, boolean space) {
            List selections = node.getSelections();
            if (selections.isEmpty()) {
                return;
            }
            this.str.append(space ? " {" : "{");
            ++this.indentLevel;
            this.line();
            this.join(selections, this.getNewLine());
            --this.indentLevel;
            this.line();
            this.str.append("}");
        }

        private void print(FragmentDefinition node) {
            this.str.append("fragment ");
            this.str.append(node.getName());
            this.str.append(" on ");
            this.print(node.getTypeCondition());
            this.wrap(" ", node.getDirectives(), " ", directives -> this.join((List)directives, " "));
            this.print(node.getSelectionSet(), true);
        }

        private void print(ArrayValue node) {
            this.wrap("[", node.getValues(), "]", values -> this.join((List)values, ", "));
        }

        private void print(BooleanValue node) {
            this.str.append(node.isValue());
        }

        private void print(EnumValue node) {
            this.str.append(node.getName());
        }

        private void print(FloatValue node) {
            this.str.append(node.getValue());
        }

        private void print(IntValue node) {
            this.str.append(node.getValue());
        }

        private void print(ObjectValue node) {
            this.wrap("{", node.getObjectFields(), "}", fields -> this.join((List)fields, ", "));
        }

        private void print(StringValue node) {
            this.wrap("\"", node.getValue(), "\"");
        }

        private void print(VariableReference node) {
            this.str.append("$");
            this.str.append(node.getName());
        }

        private void print(ListType node) {
            this.wrap("[", node.getType(), "]", this::print);
        }

        private void print(NonNullType node) {
            this.print((Node)node.getType());
            this.str.append("!");
        }

        private void print(TypeName node) {
            this.str.append(node.getName());
        }

        private void print(Argument node) {
            this.str.append(node.getName());
            this.str.append(": ");
            this.print((Node)node.getValue());
        }

        private void print(Field node) {
            String alias = node.getAlias();
            if (alias != null) {
                this.str.append(alias);
                this.str.append(": ");
            }
            this.str.append(node.getName());
            List arguments = node.getArguments();
            this.wrap("(", arguments, ")", args -> this.join((List)args, ", "));
            this.join(node.getDirectives(), " ");
            SelectionSet selectionSet = node.getSelectionSet();
            if (selectionSet != null) {
                this.print(selectionSet, true);
            }
        }

        private void print(ObjectField node) {
            this.str.append(node.getName());
            this.str.append(": ");
            this.print((Node)node.getValue());
        }

        private void print(InlineFragment node) {
            this.str.append("... on ");
            this.str.append(node.getTypeCondition().getName());
            this.str.append(" ");
            this.join(node.getDirectives(), " ");
            this.print(node.getSelectionSet());
        }

        private void print(FragmentSpread node) {
            this.str.append("...");
            this.str.append(node.getName());
            this.join(node.getDirectives(), " ");
        }
    }
}

