/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.source.RestRemoteRetriever;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class HttpRestRemoteRetriever<C extends BraidContext>
implements RestRemoteRetriever<C> {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public CompletableFuture<Map<String, Object>> get(URL url, C context) {
        return CompletableFuture.completedFuture(this.queryForJson(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> queryForJson(URL url) {
        URLConnection urlConnection = url.openConnection();
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new RuntimeException("Expected an HTTP endpoint");
        }
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        try {
            connection.setDoInput(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            if (connection.getResponseCode() != 200) {
                throw new IOException("Failed with HTTP error code: " + connection.getResponseCode());
            }
            Map map = (Map)this.mapper.readerFor(Map.class).readValue(connection.getInputStream());
            connection.disconnect();
            return map;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

