/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.MapperOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class MapperOperations {
    private MapperOperations() {
    }

    static MapperOperation noop() {
        return new NoopOperation();
    }

    static MapperOperation composed(MapperOperation ... operations) {
        return MapperOperations.composed(Arrays.asList(operations));
    }

    static MapperOperation composed(List<MapperOperation> operations) {
        return new ComposedOperation(operations);
    }

    private static class ComposedOperation
    implements MapperOperation {
        private final List<MapperOperation> operations;

        private ComposedOperation(List<MapperOperation> operations) {
            this.operations = new ArrayList<MapperOperation>(operations);
        }

        @Override
        public void accept(Map<String, Object> input, Map<String, Object> output) {
            this.operations.forEach(op -> op.accept(input, output));
        }
    }

    private static class NoopOperation
    implements MapperOperation {
        private NoopOperation() {
        }

        @Override
        public void accept(Map<String, Object> input, Map<String, Object> output) {
        }
    }
}

