/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.CopyListOperation;
import com.atlassian.braid.mapper.CopyMapOperation;
import com.atlassian.braid.mapper.CopyOperation;
import com.atlassian.braid.mapper.ListOperation;
import com.atlassian.braid.mapper.MapOperation;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.MapperOperations;
import com.atlassian.braid.mapper.PutOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class MapperImpl
implements Mapper {
    private final MapperOperation operation;

    MapperImpl() {
        this(MapperOperations.noop());
    }

    MapperImpl(MapperOperation operation) {
        this.operation = Objects.requireNonNull(operation);
    }

    @Override
    public final Map<String, Object> apply(Map<String, Object> input) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        this.operation.accept(input, (Map<String, Object>)output);
        return output;
    }

    @Override
    public <T, R> Mapper copy(String sourceKey, String targetKey, Supplier<R> defaultValue, Function<T, R> transform) {
        return this.newMapper(new CopyOperation<T, R>(sourceKey, targetKey, defaultValue, transform));
    }

    @Override
    public <V> Mapper put(String key, V value) {
        return this.newMapper(new PutOperation<V>(key, value));
    }

    @Override
    public Mapper copyList(String sourceKey, String targetKey, Mapper mapper) {
        return this.newMapper(new CopyListOperation(sourceKey, targetKey, mapper));
    }

    @Override
    public Mapper list(String key, Mapper mapper) {
        return this.newMapper(new ListOperation(key, mapper));
    }

    @Override
    public Mapper map(String key, Mapper mapper) {
        return this.newMapper(new MapOperation(key, mapper));
    }

    @Override
    public Mapper copyMap(String sourceKey, String targetKey, Mapper mapper) {
        return this.newMapper(new CopyMapOperation(sourceKey, targetKey, mapper));
    }

    private MapperImpl newMapper(MapperOperation afterOperation) {
        return new MapperImpl(this.operation.andThen(afterOperation));
    }
}

