/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Objects;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;

public class Braid {
    private final GraphQLSchema schema;
    private final List<BatchLoader> batchLoaders;

    public Braid(GraphQLSchema schema, List<BatchLoader> batchLoaders) {
        this.schema = Objects.requireNonNull(schema);
        this.batchLoaders = Objects.requireNonNull(batchLoaders);
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public DataLoaderRegistry newDataLoaderRegistry() {
        DataLoaderRegistry registry = new DataLoaderRegistry();
        for (BatchLoader loader : this.batchLoaders) {
            registry.register(loader.toString(), new DataLoader(loader));
        }
        return registry;
    }
}

