/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.source.ForwardingSchemaSource;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class LocalSchemaSource<C extends BraidContext>
extends ForwardingSchemaSource<C> {
    private final QueryExecutorSchemaSource<C> delegate;
    private final Function<ExecutionInput, Object> queryExecutor;

    public LocalSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, Function<ExecutionInput, Object> queryExecutor) {
        this(namespace, schema, Collections.emptyList(), queryExecutor);
    }

    public LocalSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, List<Link> links, Function<ExecutionInput, Object> queryExecutor) {
        this.queryExecutor = Objects.requireNonNull(queryExecutor);
        this.delegate = new QueryExecutorSchemaSource<BraidContext>(namespace, schema, links, this::query);
    }

    @Override
    protected SchemaSource<C> getDelegate() {
        return this.delegate;
    }

    private CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput executionInput, C context) {
        Object result = this.queryExecutor.apply(this.transformExecutionInput(executionInput, context));
        if (result instanceof DataFetcherResult) {
            return CompletableFuture.completedFuture(LocalSchemaSource.cast(result));
        }
        if (result instanceof Map) {
            return CompletableFuture.completedFuture(new DataFetcherResult(LocalSchemaSource.cast(result), Collections.emptyList()));
        }
        CompletableFuture<DataFetcherResult<Map<String, Object>>> future = new CompletableFuture<DataFetcherResult<Map<String, Object>>>();
        future.completeExceptionally(new IllegalStateException("Unexpected result type: " + LocalSchemaSource.nullSafeGetClass(result)));
        return future;
    }

    private ExecutionInput transformExecutionInput(ExecutionInput executionInput, C context) {
        return executionInput.transform(builder -> builder.context(context));
    }

    private static Class<?> nullSafeGetClass(Object result) {
        return Optional.ofNullable(result).map(Object::getClass).orElse(null);
    }

    private static <T> T cast(Object o) {
        return (T)o;
    }
}

