/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Braid;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.QueryExecutor;
import com.atlassian.braid.SchemaBraidConfiguration;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import graphql.language.Definition;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoaderRegistry;

public class SchemaBraid<C extends BraidContext> {
    public static final String QUERY_TYPE_NAME = "Query";
    public static final String QUERY_FIELD_NAME = "query";
    private final QueryExecutor queryExecutor;

    public SchemaBraid() {
        this(new QueryExecutor());
    }

    SchemaBraid(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Deprecated
    public Braid braid(SchemaSource<C> ... dataSources) {
        return this.braid(new TypeDefinitionRegistry(), RuntimeWiring.newRuntimeWiring(), dataSources);
    }

    @Deprecated
    public Braid braid(TypeDefinitionRegistry allTypes, RuntimeWiring.Builder wiringBuilder, SchemaSource<C> ... dataSources) {
        SchemaBraidConfiguration.SchemaBraidConfigurationBuilder configBuilder = SchemaBraidConfiguration.builder().typeDefinitionRegistry(allTypes).runtimeWiringBuilder(wiringBuilder);
        Arrays.stream(dataSources).forEach(configBuilder::schemaSource);
        return this.braid(configBuilder.build());
    }

    public Braid braid(SchemaBraidConfiguration<C> configuration) {
        Map<SchemaNamespace, Source<C>> dataSourceTypes = configuration.getSchemaSources().stream().collect(Collectors.toMap(SchemaSource::getNamespace, x$0 -> new Source((SchemaSource)x$0)));
        TypeDefinitionRegistry allTypes = configuration.getTypeDefinitionRegistry();
        SchemaDefinition schema = allTypes.schemaDefinition().orElseGet(() -> {
            SchemaDefinition s = new SchemaDefinition();
            allTypes.add((Definition)s);
            return s;
        });
        ObjectTypeDefinition query = schema.getOperationTypeDefinitions().stream().filter(d -> d.getName().equals(QUERY_FIELD_NAME)).findFirst().map(operType -> (ObjectTypeDefinition)allTypes.getType(operType.getType()).orElseThrow(IllegalArgumentException::new)).orElseGet(() -> {
            OperationTypeDefinition definition = new OperationTypeDefinition(QUERY_FIELD_NAME, (Type)new TypeName(QUERY_TYPE_NAME));
            schema.getOperationTypeDefinitions().add(definition);
            ObjectTypeDefinition queryType = new ObjectTypeDefinition(QUERY_TYPE_NAME);
            allTypes.add((Definition)queryType);
            return queryType;
        });
        RuntimeWiring.Builder wiringBuilder = configuration.getRuntimeWiringBuilder();
        List<BatchLoader> queryBatchLoaders = this.addSchemaSourceTopLevelFieldsToQuery(query, dataSourceTypes, wiringBuilder);
        List<BatchLoader> linkBatchLoaders = this.linkTypes(allTypes, dataSourceTypes, wiringBuilder);
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return new Braid(schemaGenerator.makeExecutableSchema(allTypes, wiringBuilder.build()), Stream.concat(queryBatchLoaders.stream(), linkBatchLoaders.stream()).collect(Collectors.toList()));
    }

    private List<BatchLoader> addSchemaSourceTopLevelFieldsToQuery(ObjectTypeDefinition query, Map<SchemaNamespace, Source<C>> sources, RuntimeWiring.Builder wiringBuilder) {
        ArrayList<BatchLoader> result = new ArrayList<BatchLoader>();
        for (Source<C> source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = ((Source)source).registry;
            SchemaDefinition dsSchema = (SchemaDefinition)typeRegistry.schemaDefinition().orElseThrow(IllegalArgumentException::new);
            OperationTypeDefinition dsQueryType = dsSchema.getOperationTypeDefinitions().stream().filter(d -> d.getName().equals(QUERY_FIELD_NAME)).findFirst().orElseThrow(IllegalArgumentException::new);
            ObjectTypeDefinition dsQuery = (ObjectTypeDefinition)typeRegistry.getType(dsQueryType.getType()).orElseThrow(IllegalStateException::new);
            HashMap dsTypes = new HashMap(typeRegistry.types());
            dsTypes.remove(dsQuery.getName());
            query.getFieldDefinitions().addAll(dsQuery.getFieldDefinitions());
            wiringBuilder.type(query.getName(), typeWiring -> {
                for (FieldDefinition queryField : dsQuery.getFieldDefinitions()) {
                    BatchLoader<DataFetchingEnvironment, Object> batchLoader = this.queryExecutor.asBatchLoader(((Source)source).schemaSource, null);
                    result.add(batchLoader);
                    typeWiring.dataFetcher(queryField.getName(), environment -> {
                        DataLoaderRegistry registry = ((BraidContext)environment.getContext()).getDataLoaderRegistry();
                        return registry.getDataLoader(batchLoader.toString()).load((Object)environment);
                    });
                }
                return typeWiring;
            });
        }
        return result;
    }

    private List<BatchLoader> linkTypes(TypeDefinitionRegistry allTypes, Map<SchemaNamespace, Source<C>> sources, RuntimeWiring.Builder wiringBuilder) {
        ArrayList definitionsToAdd = new ArrayList();
        ArrayList<BatchLoader> batchLoaders = new ArrayList<BatchLoader>();
        for (Source source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = source.registry;
            HashMap dsTypes = new HashMap(typeRegistry.types());
            for (Link link : source.schemaSource.getLinks()) {
                ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(link.getSourceType());
                this.validateSourceFromFieldExists(link, typeDefinition);
                Optional<FieldDefinition> sourceField = typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceField())).findFirst();
                Source<C> targetSource = sources.get(link.getTargetNamespace());
                if (!((Source)targetSource).registry.getType(link.getTargetType()).isPresent()) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                TypeName targetType = new TypeName(link.getTargetType());
                if (!sourceField.isPresent()) {
                    FieldDefinition field = new FieldDefinition(link.getSourceField(), (Type)targetType);
                    typeDefinition.getFieldDefinitions().add(field);
                } else {
                    sourceField.get().setType((Type)targetType);
                }
                BatchLoader<DataFetchingEnvironment, Object> batchLoader = this.queryExecutor.asBatchLoader(((Source)targetSource).schemaSource, link);
                batchLoaders.add(batchLoader);
                wiringBuilder.type(link.getSourceType(), typeWiring -> typeWiring.dataFetcher(link.getSourceField(), environment -> {
                    DataLoaderRegistry registry = ((BraidContext)environment.getContext()).getDataLoaderRegistry();
                    return registry.getDataLoader(batchLoader.toString()).load((Object)environment);
                }));
            }
            definitionsToAdd.addAll(dsTypes.values().stream().filter(d -> !source.operationTypes.contains(d)).collect(Collectors.toList()));
        }
        definitionsToAdd.forEach(arg_0 -> ((TypeDefinitionRegistry)allTypes).add(arg_0));
        return batchLoaders;
    }

    private void validateSourceFromFieldExists(Link link, ObjectTypeDefinition typeDefinition) {
        typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceFromField())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source from field: %s", link.getSourceFromField())));
    }

    private static class Source<C> {
        private final SchemaSource<C> schemaSource;
        private final TypeDefinitionRegistry registry;
        private final SchemaDefinition schema;
        private final Collection<Definition> operationTypes;

        private Source(SchemaSource<C> schemaSource) {
            this.schemaSource = schemaSource;
            this.registry = schemaSource.getSchema();
            this.schema = (SchemaDefinition)this.registry.schemaDefinition().orElseThrow(IllegalArgumentException::new);
            this.operationTypes = this.schema.getOperationTypeDefinitions().stream().map(opType -> (TypeDefinition)this.registry.getType(opType.getType()).orElseThrow(IllegalArgumentException::new)).collect(Collectors.toList());
        }
    }
}

