/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.DocumentCloners;
import com.atlassian.braid.GraphQLQueryPrinter;
import com.atlassian.braid.GraphQLQueryVisitor;
import com.atlassian.braid.Link;
import com.atlassian.braid.RelativeGraphQLError;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.Parser;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

class QueryExecutor {
    QueryExecutor() {
    }

    <C extends BraidContext> BatchLoader<DataFetchingEnvironment, Object> asBatchLoader(SchemaSource<C> schemaSource, Link link) {
        return environments -> this.query(schemaSource, environments, link);
    }

    <C extends BraidContext> CompletableFuture<List<Object>> query(SchemaSource<C> schemaSource, List<DataFetchingEnvironment> environments, Link link) {
        Document doc = new Document();
        final OperationDefinition queryOp = new OperationDefinition("", OperationDefinition.Operation.QUERY, new SelectionSet());
        queryOp.setName("Bulk_" + environments.stream().findFirst().map(e -> e.getFieldDefinition().getType().getName()).orElse(""));
        doc.getDefinitions().add(queryOp);
        final HashMap<String, Object> variables = new HashMap<String, Object>();
        HashMap<DataFetchingEnvironment, Field> clonedFields = new HashMap<DataFetchingEnvironment, Field>();
        int counter = 99;
        for (final DataFetchingEnvironment environment : environments) {
            Field field = this.cloneCurrentField(environment);
            field.setAlias(field.getName() + ++counter);
            clonedFields.put(environment, field);
            this.trimFieldSelection(schemaSource, environment, field);
            if (link != null) {
                String varName = link.getArgumentName() + counter;
                field.setArguments(Collections.singletonList(new Argument(link.getArgumentName(), (Value)new VariableReference(varName))));
                field.setName(link.getTargetField());
                Map<String, String> source = this.findMapSource(environment);
                Type argumentType = this.findArgumentType(schemaSource, link);
                variables.put(varName, source.get(link.getSourceField()));
                queryOp.getVariableDefinitions().add(new VariableDefinition(varName, argumentType));
            }
            Document queryDoc = new Parser().parseDocument(((BraidContext)environment.getContext()).getQuery());
            final OperationDefinition queryType = this.findQueryDefinition(queryDoc);
            this.processForFragments(environment, field).forEach(d -> doc.getDefinitions().add(d));
            queryOp.getSelectionSet().getSelections().add(field);
            final int finalCounter = counter;
            new GraphQLQueryVisitor(){

                @Override
                protected void visitField(Field node) {
                    List renamedArguments = node.getArguments().stream().map(a -> {
                        VariableReference varRef;
                        Value value = a.getValue();
                        if (value instanceof VariableReference && this.isVariableNotAlreadyNamespaced(varRef = (VariableReference)value)) {
                            value = this.namespaceVariable(varRef);
                        }
                        return new Argument(a.getName(), value);
                    }).collect(Collectors.toList());
                    node.setArguments(renamedArguments);
                    super.visitField(node);
                }

                private Value namespaceVariable(VariableReference varRef) {
                    VariableReference value = new VariableReference(varRef.getName() + finalCounter);
                    Type type = QueryExecutor.this.findVariableType(varRef, queryType);
                    variables.put(varRef.getName() + finalCounter, ((BraidContext)environment.getContext()).getVariables().get(varRef.getName()));
                    queryOp.getVariableDefinitions().add(new VariableDefinition(varRef.getName() + finalCounter, type));
                    return value;
                }

                private boolean isVariableNotAlreadyNamespaced(VariableReference varRef) {
                    return !varRef.getName().endsWith(String.valueOf(finalCounter));
                }
            }.visit((Node)doc);
        }
        ExecutionInput input = this.executeBatchQuery(doc, queryOp.getName(), variables);
        return schemaSource.query(input, environments.get(0).getContext()).thenApply(result -> this.transformBatchResultIntoResultList(environments, clonedFields, (DataFetcherResult<Map<String, Object>>)result));
    }

    private Field cloneCurrentField(DataFetchingEnvironment environment) {
        Field original = this.findFieldWithName(environment);
        return DocumentCloners.clone(original);
    }

    private ExecutionInput executeBatchQuery(Document doc, String operationName, Map<String, Object> variables) {
        GraphQLQueryPrinter printer = new GraphQLQueryPrinter();
        String query = printer.print((Node)doc);
        return ExecutionInput.newExecutionInput().query(query).operationName(operationName).variables(variables).build();
    }

    private Type findVariableType(VariableReference varRef, OperationDefinition queryType) {
        return queryType.getVariableDefinitions().stream().filter(d -> d.getName().equals(varRef.getName())).map(VariableDefinition::getType).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    private List<Object> transformBatchResultIntoResultList(List<DataFetchingEnvironment> environments, Map<DataFetchingEnvironment, Field> clonedFields, DataFetcherResult<Map<String, Object>> result) {
        ArrayList<Object> queryResults = new ArrayList<Object>();
        Map data = (Map)result.getData();
        for (DataFetchingEnvironment environment : environments) {
            Field field = clonedFields.get(environment);
            Object fieldData = data.getOrDefault(field.getAlias(), null);
            queryResults.add(new DataFetcherResult(fieldData, result.getErrors().stream().filter(e -> e.getPath() == null || e.getPath().isEmpty() || field.getAlias().equals(e.getPath().get(0))).map(RelativeGraphQLError::new).collect(Collectors.toList())));
        }
        return queryResults;
    }

    private OperationDefinition findQueryDefinition(Document queryDoc) {
        return (OperationDefinition)queryDoc.getDefinitions().stream().filter(d -> d instanceof OperationDefinition && ((OperationDefinition)d).getOperation() == OperationDefinition.Operation.QUERY).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    private <C extends BraidContext> Type findArgumentType(SchemaSource<C> schemaSource, Link link) {
        return TypeUtils.findQueryType(schemaSource.getSchema()).getFieldDefinitions().stream().filter(f -> f.getName().equals(link.getTargetField())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getArgumentName())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }

    private Map<String, String> findMapSource(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        while (!(source instanceof Map)) {
            if (source instanceof CompletableFuture) {
                try {
                    source = ((CompletableFuture)source).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (source instanceof DataFetcherResult) {
                source = ((DataFetcherResult)source).getData();
                continue;
            }
            throw new IllegalArgumentException("Unexpected parent type");
        }
        return (Map)source;
    }

    private Field findFieldWithName(DataFetchingEnvironment environment) {
        return environment.getFields().stream().filter(f -> environment.getFieldDefinition().getName().equals(f.getName())).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    <C> void trimFieldSelection(final SchemaSource<C> schemaSource, final DataFetchingEnvironment environment, final Field field) {
        new GraphQLQueryVisitor(){
            GraphQLOutputType parentType = null;
            GraphQLOutputType lastFieldType = null;

            @Override
            protected void visitField(Field node) {
                GraphQLOutputType type;
                if (node == field) {
                    type = environment.getFieldType();
                } else {
                    QueryExecutor.this.getLink(schemaSource.getLinks(), this.parentType.getName(), node.getName()).ifPresent(l -> node.setSelectionSet(null));
                    type = ((GraphQLObjectType)this.parentType).getFieldDefinition(node.getName()).getType();
                }
                while (type instanceof GraphQLModifiedType) {
                    type = ((GraphQLModifiedType)type).getWrappedType();
                }
                this.lastFieldType = type;
                super.visitField(node);
            }

            @Override
            protected void visitSelectionSet(SelectionSet node) {
                if (node == null) {
                    return;
                }
                if (!node.getChildren().isEmpty()) {
                    GraphQLOutputType lastParentType = this.parentType;
                    this.parentType = this.lastFieldType;
                    for (Node child : node.getChildren()) {
                        this.visit(child);
                    }
                    this.parentType = lastParentType;
                }
            }
        }.visit((Node)field);
    }

    Collection<Definition> processForFragments(final DataFetchingEnvironment environment, Field field) {
        final HashMap result = new HashMap();
        new GraphQLQueryVisitor(){

            @Override
            protected void visitFragmentSpread(FragmentSpread node) {
                FragmentDefinition fragmentDefinition = (FragmentDefinition)environment.getFragmentsByName().get(node.getName());
                result.put(node.getName(), fragmentDefinition.deepCopy());
                super.visitFragmentSpread(node);
            }
        }.visit((Node)field);
        return result.values();
    }

    private Optional<Link> getLink(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceField().equals(fieldName)).findFirst();
    }
}

