/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.DefaultScalarCoercing;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.AliasablePropertyDataFetcher;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidTypeDefinition;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.ExtensionSchemaTransformation;
import com.atlassian.braid.transformation.LinkSchemaTransformation;
import com.atlassian.braid.transformation.SchemaTransformation;
import com.atlassian.braid.transformation.TopLevelSchemaTransformation;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;

final class BraidSchema {
    private final GraphQLSchema schema;
    private final Map<String, BatchLoader> batchLoaders;
    private static final List<SchemaTransformation> schemaTransformations = Arrays.asList(new LinkSchemaTransformation(), new TopLevelSchemaTransformation(), new ExtensionSchemaTransformation());

    private BraidSchema(GraphQLSchema schema, Map<String, BatchLoader> batchLoaders) {
        this.schema = Objects.requireNonNull(schema);
        this.batchLoaders = Objects.requireNonNull(batchLoaders);
    }

    static BraidSchema from(TypeDefinitionRegistry typeDefinitionRegistry, RuntimeWiring.Builder runtimeWiringBuilder, List<SchemaSource> schemaSources) {
        return BraidSchema.from(typeDefinitionRegistry, runtimeWiringBuilder, schemaSources, Collections.emptyList(), null);
    }

    static BraidSchema from(TypeDefinitionRegistry typeDefinitionRegistry, RuntimeWiring.Builder runtimeWiringBuilder, List<SchemaSource> schemaSources, List<SchemaTransformation> customSchemaTransformations, BatchLoaderEnvironment batchLoaderEnvironment) {
        Map<SchemaNamespace, BraidSchemaSource> dataSourceTypes = BraidSchema.toBraidSchemaSourceMap(schemaSources);
        BraidSchema.findSchemaDefinitionOrCreateOne(typeDefinitionRegistry);
        ObjectTypeDefinition queryObjectTypeDefinition = TypeUtils.findQueryType(typeDefinitionRegistry).orElseGet(() -> TypeUtils.addQueryTypeToSchema(typeDefinitionRegistry, TypeUtils.createDefaultQueryTypeDefinition()));
        ObjectTypeDefinition mutationObjectTypeDefinition = TypeUtils.findMutationType(typeDefinitionRegistry).orElseGet(TypeUtils::createDefaultMutationTypeDefinition);
        Map<String, BatchLoader> batchLoaders = BraidSchema.addDataSources(dataSourceTypes, typeDefinitionRegistry, runtimeWiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition, customSchemaTransformations, batchLoaderEnvironment);
        if (!mutationObjectTypeDefinition.getFieldDefinitions().isEmpty()) {
            TypeUtils.addMutationTypeToSchema(typeDefinitionRegistry, mutationObjectTypeDefinition);
        }
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, runtimeWiringBuilder.build());
        return new BraidSchema(graphQLSchema, batchLoaders);
    }

    private static void findSchemaDefinitionOrCreateOne(TypeDefinitionRegistry typeDefinitionRegistry) {
        typeDefinitionRegistry.schemaDefinition().orElseGet(() -> BraidSchema.createDefaultSchemaDefinition(typeDefinitionRegistry));
    }

    private static SchemaDefinition createDefaultSchemaDefinition(TypeDefinitionRegistry typeDefinitionRegistry) {
        SchemaDefinition.Builder builder = SchemaDefinition.newSchemaDefinition();
        typeDefinitionRegistry.getType("Query").ifPresent(__ -> BraidSchema.addOperation(builder, "query", "Query"));
        typeDefinitionRegistry.getType("Mutation").ifPresent(__ -> BraidSchema.addOperation(builder, "mutation", "Mutation"));
        SchemaDefinition schemaDefinition = builder.build();
        typeDefinitionRegistry.add((SDLDefinition)schemaDefinition);
        return schemaDefinition;
    }

    private static void addOperation(SchemaDefinition.Builder schemaDefinition, String queryFieldName, String defaultQueryTypeName) {
        schemaDefinition.operationTypeDefinition(new OperationTypeDefinition(queryFieldName, (Type)new TypeName(defaultQueryTypeName)));
    }

    private static Map<String, BatchLoader> addDataSources(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, List<SchemaTransformation> customSchemaTransformations, BatchLoaderEnvironment batchLoaderEnvironment) {
        BraidSchema.addAllNonOperationTypes(dataSources, registry, runtimeWiringBuilder);
        BraidingContext braidingContext = new BraidingContext(dataSources, registry, runtimeWiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition, batchLoaderEnvironment);
        return Stream.concat(schemaTransformations.stream(), customSchemaTransformations.stream()).map(schemaTransformation -> schemaTransformation.transform(braidingContext)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    Map<String, BatchLoader> getBatchLoaders() {
        return Collections.unmodifiableMap(this.batchLoaders);
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    private static void addAllNonOperationTypes(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder) {
        Map<String, List<BraidTypeDefinition>> allNonOperationTypeDefinitions = dataSources.values().stream().map(BraidSchemaSource::getNonOperationTypes).flatMap(Collection::stream).collect(Collectors.groupingBy(BraidTypeDefinition::getName));
        List duplicateTypes = allNonOperationTypeDefinitions.values().stream().filter(e -> e.size() > 1).collect(Collectors.toList());
        if (!duplicateTypes.isEmpty()) {
            duplicateTypes.stream().flatMap(Collection::stream).forEach(c -> System.out.printf("Type `%s` from %s is in conflict\n", c.getName(), c.getNamespace()));
            throw new IllegalStateException("Type name conflict exists");
        }
        BraidSchema.wireScalarDefinitions(dataSources, registry, runtimeWiringBuilder);
        allNonOperationTypeDefinitions.values().stream().map(types -> (BraidTypeDefinition)types.get(0)).peek(type -> BraidSchema.wireFieldDefinitions(runtimeWiringBuilder, type.getType(), type.getFieldDefinitions())).map(BraidTypeDefinition::getType).forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0));
        dataSources.values().stream().map(d -> d.getTypeRegistry().getDirectiveDefinitions().values()).forEach(t -> t.stream().forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0)));
    }

    private static void wireFieldDefinitions(RuntimeWiring.Builder runtimeWiringBuilder, TypeDefinition type, List<FieldDefinition> fieldDefinitions) {
        fieldDefinitions.forEach(fd -> runtimeWiringBuilder.type(type.getName(), wiring -> wiring.dataFetcher(fd.getName(), (DataFetcher)new AliasablePropertyDataFetcher(fd.getName()))));
    }

    private static void wireScalarDefinitions(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder) {
        Function<TypeDefinitionRegistry, Map> scalars = TypeDefinitionRegistry::scalars;
        dataSources.values().stream().map(BraidSchemaSource::getTypeRegistry).map(scalars).map(Map::values).flatMap(Collection::stream).forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0));
        Predicate<String> notAlreadyWired = BraidSchema.isNotAlreadyWired(runtimeWiringBuilder.build().getScalars());
        registry.scalars().values().stream().map(ScalarTypeDefinition::getName).filter(notAlreadyWired).map(scalarName -> new GraphQLScalarType(scalarName, "", (Coercing)new DefaultScalarCoercing())).forEach(arg_0 -> ((RuntimeWiring.Builder)runtimeWiringBuilder).scalar(arg_0));
    }

    private static Predicate<String> isNotAlreadyWired(Map<String, GraphQLScalarType> wiredScalarTypeByName) {
        return scalarName -> !wiredScalarTypeByName.containsKey(scalarName);
    }

    private static Map<SchemaNamespace, BraidSchemaSource> toBraidSchemaSourceMap(List<SchemaSource> schemaSources) {
        return schemaSources.stream().map(BraidSchemaSource::new).collect(Collectors.groupingBy(BraidSchemaSource::getNamespace, BraidCollectors.singleton()));
    }
}

