/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.java.util.BraidObjects;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MapGraphQLError
implements GraphQLError {
    private final String message;
    private final List<SourceLocation> locations;
    private final ErrorType errorType;
    private final List<Object> path;
    private final Map<String, Object> extensions;

    public MapGraphQLError(Map<String, Object> error) {
        this.message = Optional.ofNullable(error.get("message")).map(String.class::cast).orElse("Unknown error");
        this.locations = Optional.ofNullable(error.get("locations")).map(BraidObjects::cast).map(errors -> errors.stream().filter(err -> err.containsKey("line") && err.containsKey("column")).map(err -> new SourceLocation(MapGraphQLError.parseInt(err.get("line")).intValue(), MapGraphQLError.parseInt(err.get("column")).intValue())).collect(Collectors.toList())).orElse(null);
        this.errorType = ErrorType.DataFetchingException;
        this.path = Optional.ofNullable(error.get("path")).map(BraidObjects::cast).orElse(null);
        this.extensions = Optional.ofNullable(error.get("extensions")).map(BraidObjects::cast).orElse(null);
    }

    private static Integer parseInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return -1;
    }

    public String getMessage() {
        return this.message;
    }

    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public List<Object> getPath() {
        return this.path;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }
}

