/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.Extension;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.KeyedDataFetchingEnvironment;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidTypeDefinition;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.ExtensionTransformation;
import com.atlassian.braid.transformation.SchemaTransformation;
import graphql.execution.DataFetcherResult;
import graphql.execution.MergedField;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.StringValue;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.dataloader.BatchLoader;

public class ExtensionSchemaTransformation
implements SchemaTransformation {
    private static Directive deprecated = Directive.newDirective().name("deprecated").argument(Argument.newArgument().name("reason").value((Value)StringValue.newStringValue((String)"Extension field").build()).build()).build();

    @Override
    public Map<String, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>>> transform(BraidingContext ctx) {
        TypeDefinitionRegistry typeRegistry = ctx.getRegistry();
        ObjectTypeDefinition queryType = ctx.getQueryObjectTypeDefinition();
        return BraidTypeDefinition.getFieldDefinitions((TypeDefinition)queryType).stream().flatMap(topLevelField -> ctx.getDataSources().values().stream().filter(braidSchemaSource -> braidSchemaSource.hasTypeAndField(typeRegistry, (TypeDefinition)queryType, (FieldDefinition)topLevelField)).flatMap(braidSchemaSource -> {
            String topLevelFieldType = braidSchemaSource.getSourceTypeName(TypeUtils.unwrap(topLevelField.getType()));
            return braidSchemaSource.getExtensions(topLevelFieldType).stream().map(ext -> this.mergeType((BraidSchemaSource)braidSchemaSource, ctx, (TypeDefinition)queryType, (FieldDefinition)topLevelField, (Extension)ext)).flatMap(m -> m.entrySet().stream());
        })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>>> mergeType(BraidSchemaSource braidSchemaSource, BraidingContext ctx, TypeDefinition containingType, FieldDefinition field, Extension ext) {
        ObjectTypeDefinition originalType = this.findRequiredOriginalType(ctx, braidSchemaSource, field);
        Set<String> originalTypeFieldNames = originalType.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toSet());
        BraidSchemaSource targetSource = ctx.getDataSources().get(ext.getBy().getNamespace());
        ObjectTypeDefinition targetType = this.findRequiredTargetType(targetSource, ext);
        String key = "ext-" + containingType.getName();
        this.wireNewFields(ctx, braidSchemaSource, containingType, field, ext, originalType, originalTypeFieldNames, targetType, key);
        SchemaSource schemaSource = ctx.getDataSources().get(ext.getBy().getNamespace()).getSchemaSource();
        return Collections.singletonMap(key, schemaSource.newBatchLoader(schemaSource, new ExtensionTransformation(ext), ctx.getBatchLoaderEnvironment()));
    }

    private ObjectTypeDefinition findRequiredTargetType(BraidSchemaSource targetSource, Extension ext) {
        return (ObjectTypeDefinition)targetSource.getType(ext.getBy().getType()).orElseThrow(IllegalAccessError::new);
    }

    private ObjectTypeDefinition findRequiredOriginalType(BraidingContext ctx, BraidSchemaSource braidSchemaSource, FieldDefinition fieldDef) {
        return (ObjectTypeDefinition)ctx.getRegistry().getType(braidSchemaSource.getBraidTypeName(TypeUtils.unwrap(fieldDef.getType()))).orElseThrow(IllegalArgumentException::new);
    }

    private void wireNewFields(BraidingContext ctx, BraidSchemaSource braidSchemaSource, TypeDefinition containingType, FieldDefinition field, Extension ext, ObjectTypeDefinition originalType, Set<String> originalTypeFieldNames, ObjectTypeDefinition targetType, String key) {
        ArrayList fieldDefinitions = new ArrayList(originalType.getFieldDefinitions());
        targetType.getFieldDefinitions().stream().filter(extField -> !originalTypeFieldNames.contains(extField.getName())).forEach(extField -> {
            fieldDefinitions.add(extField.transform(builder -> builder.directive(deprecated)));
            String braidType = braidSchemaSource.getBraidTypeName(ext.getType());
            String extFieldName = extField.getName();
            DataFetcher extFieldFetcher = this.buildDataFetcher(braidSchemaSource, containingType, field, key, extFieldName);
            ctx.registerDataFetcher(braidType, extFieldName, extFieldFetcher);
        });
        ObjectTypeDefinition modifiedOriginalType = originalType.transform(builder -> builder.fieldDefinitions(fieldDefinitions));
        ctx.getRegistry().remove((SDLDefinition)originalType);
        ctx.getRegistry().add((SDLDefinition)modifiedOriginalType);
    }

    private DataFetcher buildDataFetcher(BraidSchemaSource braidSchemaSource, TypeDefinition containingType, FieldDefinition field, String key, String extFieldName) {
        return env -> ((CompletableFuture)env.getDataLoader(key).load((Object)new KeyedDataFetchingEnvironment(ExtensionSchemaTransformation.updateDataFetchingEnvironment(braidSchemaSource, containingType, field, env))).thenApply(BraidObjects::cast)).thenApply(dfr -> ExtensionSchemaTransformation.nullSafeGetFieldValue((DataFetcherResult<Map<String, Object>>)dfr, extFieldName));
    }

    private static Object nullSafeGetFieldValue(@Nullable DataFetcherResult<Map<String, Object>> dfr, String fieldName) {
        return Optional.ofNullable(dfr).flatMap(r -> Optional.ofNullable((Map)r.getData())).map(data -> data.get(fieldName)).orElse(null);
    }

    private static DataFetchingEnvironment updateDataFetchingEnvironment(BraidSchemaSource braidSchemaSource, TypeDefinition containingType, FieldDefinition field, DataFetchingEnvironment env) {
        GraphQLSchema graphQLSchema = env.getGraphQLSchema();
        GraphQLObjectType containingGraphQLType = graphQLSchema.getObjectType(braidSchemaSource.getBraidTypeName(containingType.getName()));
        return DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)env).source(env.getSource()).fieldDefinition(containingGraphQLType.getFieldDefinition(field.getName())).mergedField(MergedField.newMergedField().addField(new Field(field.getName())).build()).fieldType((GraphQLOutputType)graphQLSchema.getObjectType(((TypeName)field.getType()).getName())).parentType((GraphQLType)graphQLSchema.getObjectType("Query")).build();
    }
}

