/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.RootDefinitionMappingResult;
import com.atlassian.braid.mapper.MapperOperation;
import graphql.language.Definition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;

final class MappedDefinitions {
    private final List<Definition> definitions = new ArrayList<Definition>();
    private final List<MapperOperation> mappers = new ArrayList<MapperOperation>();

    private MappedDefinitions() {
    }

    private void add(RootDefinitionMappingResult<Definition> result) {
        this.definitions.add(result.toDefinition());
        this.mappers.addAll(result.getMapperOperations());
    }

    private static MappedDefinitions combine(MappedDefinitions mos1, MappedDefinitions mos2) {
        MappedDefinitions mappedDefinitions = new MappedDefinitions();
        mappedDefinitions.definitions.addAll(mos1.definitions);
        mappedDefinitions.definitions.addAll(mos2.definitions);
        mappedDefinitions.mappers.addAll(mos1.mappers);
        mappedDefinitions.mappers.addAll(mos2.mappers);
        return mappedDefinitions;
    }

    List<Definition> getDefinitions() {
        return this.definitions;
    }

    List<MapperOperation> getMappers() {
        return this.mappers;
    }

    static Collector<RootDefinitionMappingResult, MappedDefinitions, MappedDefinitions> toMappedDefinitions() {
        return Collector.of(MappedDefinitions::new, MappedDefinitions::add, MappedDefinitions::combine, new Collector.Characteristics[0]);
    }
}

