/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.java.util.BraidLists;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.CopyOperation;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.SpringExpressions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.LoggerFactory;

final class MapperMaps {
    private static BiFunction<Map<String, Object>, String, Optional<Object>> getFromMap;

    private MapperMaps() {
    }

    public static <V> Optional<V> get(Map<String, Object> map, String key) {
        return getFromMap.apply(map, key).map(BraidObjects::cast);
    }

    static Map<String, Object> mergeMaps(Map<String, Object> map1, Map<String, Object> map2) {
        if (map1.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return map1;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(map1);
        map2.forEach((key, value) -> MapperMaps.mergeEntry(merged, key, value));
        return merged;
    }

    private static void mergeEntry(Map<String, Object> merged, String key, Object value) {
        if (!merged.containsKey(key)) {
            merged.put(key, value);
        } else {
            merged.put(key, MapperMaps.mergeValues(merged.get(key), value));
        }
    }

    private static Object mergeValues(Object value1, Object value2) {
        if (value1 instanceof Map && value2 instanceof Map) {
            return MapperMaps.mergeMaps((Map)BraidObjects.cast(value1), (Map)BraidObjects.cast(value2));
        }
        if (value1 instanceof List && value2 instanceof List) {
            return BraidLists.concat((List)BraidObjects.cast(value1), (List)BraidObjects.cast(value2));
        }
        throw new IllegalStateException("Can't merge values, getting non-mergeable types");
    }

    private static <T> T newInstance(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return BraidObjects.cast(Mapper.class.getClassLoader().loadClass(name).newInstance());
    }

    static {
        try {
            getFromMap = ((SpringExpressions)MapperMaps.newInstance("com.atlassian.braid.mapper.SpringExpressions"))::get;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger(CopyOperation.class).debug("Spring not found, using simple property expressions", (Throwable)e);
            getFromMap = BraidMaps::get;
        }
    }
}

