/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.BatchLoaderFactory;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.BraidContexts;
import com.atlassian.braid.FieldKey;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeRename;
import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.graphql.language.DocumentTransformations;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.Query;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.QueryFunction;
import com.atlassian.braid.source.RelativeGraphQLError;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.LinkTransformation;
import com.google.common.base.Strings;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

class QueryExecutor<C>
implements BatchLoaderFactory {
    private final QueryFunction<C> queryFunction;

    QueryExecutor(QueryFunction<C> queryFunction) {
        this.queryFunction = Objects.requireNonNull(queryFunction);
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, FieldTransformation fieldTransformation, BatchLoaderEnvironment batchLoaderEnvironment) {
        return new QueryExecutorBatchLoader<C>((QueryExecutorSchemaSource)BraidObjects.cast(schemaSource), this.queryFunction, fieldTransformation, batchLoaderEnvironment);
    }

    private static DataFetcherResult<Map<FieldKey, Object>> resultWithMappedData(DocumentMapper.MappedDocument mappedDocument, DataFetcherResult<Map<FieldKey, Object>> result) {
        Function<Map<String, Object>, Map<String, Object>> mapper = mappedDocument.getResultMapper();
        HashMap data = new HashMap();
        ((Map)result.getData()).forEach((key, value) -> data.put(key.getValue(), value));
        Map<String, Object> newData = mapper.apply(data);
        HashMap resultData = new HashMap();
        newData.forEach((key, value) -> resultData.put(new FieldKey((String)key), value));
        return DataFetcherResult.newResult().data(resultData).errors(result.getErrors()).localContext(result.getLocalContext()).build();
    }

    private static DataFetcherResult<Map<FieldKey, Object>> resultWithShortCircuitedData(Map<FieldKey, Object> shortCircuitedData, DataFetcherResult<Map<String, Object>> result) {
        HashMap<FieldKey, Object> data = new HashMap<FieldKey, Object>();
        Map<FieldKey, Object> dataByKey = ((Map)result.getData()).entrySet().stream().collect(BraidCollectors.nullSafeToMap(e -> new FieldKey((String)e.getKey()), Map.Entry::getValue));
        data.putAll(dataByKey);
        data.putAll(shortCircuitedData);
        return DataFetcherResult.newResult().data(data).errors(result.getErrors()).build();
    }

    private static String newBulkOperationName(BraidSchemaSource braidSchemaSource, GraphQLNamedType fieldType) {
        GraphQLUnmodifiedType type = GraphQLTypeUtil.unwrapAll((GraphQLType)fieldType);
        String originalTypeName = braidSchemaSource.getTypeRenameFromBraidName(type.getName()).map(TypeRename::getSourceName).orElse(type.getName());
        String operationNamePrefix = Strings.isNullOrEmpty((String)braidSchemaSource.getOperationNamePrefix()) ? "Bulk" : braidSchemaSource.getOperationNamePrefix();
        return operationNamePrefix + "_" + originalTypeName;
    }

    private static Query createBatchQuery(Document doc, String operationName, Map<String, Object> variables) {
        return Query.newQuery().query(doc).operationName(operationName).variables(variables).build();
    }

    private static List<GraphQLError> buildDataFetcherResultErrors(DataFetcherResult<Map<FieldKey, Object>> result, List<FieldKey> fields, DataFetchingEnvironment environment) {
        return result.getErrors().stream().filter(e -> e.getPath() == null || e.getPath().isEmpty() || fields.contains(new FieldKey(String.valueOf(e.getPath().get(0))))).map(error -> new RelativeGraphQLError((GraphQLError)error, environment.getExecutionStepInfo().getPath())).collect(Collectors.toList());
    }

    private static class QueryExecutorBatchLoader<C>
    implements BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> {
        private final QueryExecutorSchemaSource<C> schemaSource;
        private final FieldTransformation fieldTransformation;
        private final QueryFunction<C> queryFunction;
        private final BraidSchemaSource braidSchemaSource;
        private final BatchLoaderEnvironment batchLoaderEnvironment;

        private QueryExecutorBatchLoader(QueryExecutorSchemaSource<C> schemaSource, QueryFunction<C> queryFunction, FieldTransformation fieldTransformation, BatchLoaderEnvironment batchLoaderEnvironment) {
            this.schemaSource = Objects.requireNonNull(schemaSource);
            this.braidSchemaSource = new BraidSchemaSource(schemaSource);
            this.fieldTransformation = fieldTransformation;
            this.queryFunction = Objects.requireNonNull(queryFunction);
            this.batchLoaderEnvironment = batchLoaderEnvironment;
        }

        public CompletionStage<List<DataFetcherResult<Object>>> load(List<DataFetchingEnvironment> environments) {
            return this.batchLoaderEnvironment == null || this.batchLoaderEnvironment.getQueryPartitionFunction() == null ? this.loadInternal(environments) : this.batchLoaderEnvironment.getQueryPartitionFunction().apply(environments, this::loadInternal);
        }

        private CompletionStage<List<DataFetcherResult<Object>>> loadInternal(List<DataFetchingEnvironment> environments) {
            C context = QueryExecutorBatchLoader.checkAndGetContext(environments);
            OperationDefinition.Operation operationType = QueryExecutorBatchLoader.checkAndGetOperationType(environments).orElse(OperationDefinition.Operation.QUERY);
            GraphQLNamedType fieldOutputType = QueryExecutorBatchLoader.checkAndGetFieldOutputType(environments);
            String operationName = QueryExecutor.newBulkOperationName(this.braidSchemaSource, fieldOutputType);
            FieldTransformationContext fieldTransformationContext = new FieldTransformationContext(this.schemaSource, operationName, operationType);
            CompletableFuture[] fieldFutures = (CompletableFuture[])environments.stream().map(env -> this.fieldTransformation.apply((DataFetchingEnvironment)env, fieldTransformationContext).thenAccept(fields -> {
                List fieldKeys = fields.stream().map(Field::getAlias).map(FieldKey::new).collect(Collectors.toList());
                fieldTransformationContext.getClonedFields().put((DataFetchingEnvironment)env, fieldKeys);
            })).toArray(CompletableFuture[]::new);
            if (environments.size() > 1 && this.fieldTransformation instanceof LinkTransformation && ((LinkTransformation)this.fieldTransformation).getBatchMapping() != null) {
                return CompletableFuture.allOf(fieldFutures).thenCompose(__ -> ((LinkTransformation)this.fieldTransformation).batchQueries(environments, fieldTransformationContext));
            }
            return CompletableFuture.allOf(fieldFutures).thenCompose(__ -> {
                DocumentMapper.MappedDocument mappedDocument = (DocumentMapper.MappedDocument)this.schemaSource.getDocumentMapper().apply(context, fieldTransformationContext.getDocument());
                Document renamedTypesDoc = DocumentTransformations.renameTypesToSourceNames(this.braidSchemaSource, mappedDocument.getDocument());
                Document noMissingFieldsDoc = DocumentTransformations.removeMissingFieldsIfBraidAndSourceTypeFieldsDiffer(fieldTransformationContext, renamedTypesDoc, fieldOutputType);
                mappedDocument = new DocumentMapper.MappedDocument(noMissingFieldsDoc, mappedDocument.getResultMapper());
                return this.queryAndHandleResult(environments, context, fieldOutputType, fieldTransformationContext, mappedDocument);
            });
        }

        private CompletionStage<List<DataFetcherResult<Object>>> queryAndHandleResult(List<DataFetchingEnvironment> environments, C context, GraphQLNamedType fieldOutputType, FieldTransformationContext fieldTransformationContext, DocumentMapper.MappedDocument mappedDocument) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.executeQuery(context, mappedDocument.getDocument(), fieldTransformationContext).thenApply(result -> QueryExecutor.resultWithShortCircuitedData(fieldTransformationContext.getShortCircuitedData(), (DataFetcherResult<Map<String, Object>>)result))).thenApply(result -> QueryExecutor.resultWithMappedData(mappedDocument, (DataFetcherResult<Map<FieldKey, Object>>)result))).thenApply(result -> this.transformBatchResultIntoResultList(environments, fieldTransformationContext.getClonedFields(), (DataFetcherResult<Map<FieldKey, Object>>)result))).thenApply(result -> result.stream().map(dfr -> {
                if (fieldTransformationContext.getMissingFields().isEmpty()) {
                    return dfr;
                }
                ((BraidContext)((DataFetchingEnvironment)environments.get(0)).getContext()).addMissingFields(fieldOutputType.getName(), fieldTransformationContext.getMissingFields());
                return dfr;
            }).collect(Collectors.toList()));
        }

        private List<DataFetcherResult<Object>> transformBatchResultIntoResultList(List<DataFetchingEnvironment> environments, Map<DataFetchingEnvironment, List<FieldKey>> clonedFields, DataFetcherResult<Map<FieldKey, Object>> result) {
            ArrayList<DataFetcherResult<Object>> queryResults = new ArrayList<DataFetcherResult<Object>>();
            Map data = (Map)result.getData();
            for (DataFetchingEnvironment environment : environments) {
                DataFetcherResult dataFetcherResult;
                List<FieldKey> fields = clonedFields.get(environment);
                if (!fields.isEmpty()) {
                    FieldKey field = fields.get(0);
                    Object fieldData = BraidObjects.cast(data.getOrDefault(field, null));
                    if (environment.getFieldType() instanceof GraphQLList && !(fieldData instanceof List)) {
                        fieldData = fields.stream().map(f -> BraidObjects.cast(data.getOrDefault(f, null))).collect(Collectors.toList());
                    } else if (fields.size() > 1) {
                        throw new IllegalStateException("Can't query for multiple fields if the target type isn't a list");
                    }
                    dataFetcherResult = DataFetcherResult.newResult().data(fieldData).errors(QueryExecutor.buildDataFetcherResultErrors(result, fields, environment)).build();
                } else {
                    dataFetcherResult = environment.getSource() instanceof Map && ((Map)environment.getSource()).get(environment.getFieldDefinition().getName()) instanceof List ? DataFetcherResult.newResult().data(Collections.emptyList()).errors(QueryExecutor.buildDataFetcherResultErrors(result, fields, environment)).build() : DataFetcherResult.newResult().data(null).errors(QueryExecutor.buildDataFetcherResultErrors(result, fields, environment)).build();
                }
                dataFetcherResult = this.fieldTransformation.unapply(environment, (DataFetcherResult<Object>)dataFetcherResult);
                queryResults.add((DataFetcherResult<Object>)dataFetcherResult);
            }
            return queryResults;
        }

        private static <C> C checkAndGetContext(Collection<DataFetchingEnvironment> environments) {
            return (C)environments.stream().map(BraidContexts::get).collect(BraidCollectors.singleton(BraidCollectors.SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES));
        }

        private static Optional<OperationDefinition.Operation> checkAndGetOperationType(Collection<DataFetchingEnvironment> environments) {
            return (Optional)environments.stream().map(QueryExecutorBatchLoader::getOperationType).collect(BraidCollectors.singleton(BraidCollectors.SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES));
        }

        private static Optional<OperationDefinition.Operation> getOperationType(DataFetchingEnvironment env) {
            GraphQLType graphQLType = env.getParentType();
            GraphQLSchema graphQLSchema = env.getGraphQLSchema();
            if (Objects.equals(graphQLSchema.getQueryType(), graphQLType)) {
                return Optional.of(OperationDefinition.Operation.QUERY);
            }
            if (Objects.equals(graphQLSchema.getMutationType(), graphQLType)) {
                return Optional.of(OperationDefinition.Operation.MUTATION);
            }
            return Optional.empty();
        }

        private static GraphQLNamedType checkAndGetFieldOutputType(List<DataFetchingEnvironment> environments) {
            return (GraphQLNamedType)environments.stream().map(env -> GraphQLTypeUtil.unwrapAll((GraphQLType)env.getFieldDefinition().getType())).collect(BraidCollectors.singleton(BraidCollectors.SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES));
        }

        private CompletableFuture<DataFetcherResult<Map<String, Object>>> executeQuery(C context, Document doc, FieldTransformationContext fieldTransformationContext) {
            CompletableFuture<DataFetcherResult<Map<String, Object>>> queryResult;
            OperationDefinition queryOp = fieldTransformationContext.getOperation();
            if (queryOp.getSelectionSet().getSelections().isEmpty()) {
                queryResult = CompletableFuture.completedFuture(DataFetcherResult.newResult().data(Collections.emptyMap()).build());
            } else {
                Query input = QueryExecutor.createBatchQuery(doc, queryOp.getName(), fieldTransformationContext.getVariables());
                queryResult = this.queryFunction.query(input, context);
            }
            return queryResult;
        }
    }
}

