/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.source.SchemaLoader;
import com.atlassian.braid.source.SchemaUtils;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

public class UrlSchemaLoader
implements SchemaLoader {
    private final SchemaLoader.Type type;
    private final URL url;

    public UrlSchemaLoader(URL url) {
        this.type = url.getPath().endsWith(".json") ? SchemaLoader.Type.INTROSPECTION : SchemaLoader.Type.IDL;
        this.url = url;
    }

    public UrlSchemaLoader(SchemaLoader.Type type, URL url) {
        this.type = type;
        this.url = url;
    }

    @Override
    public TypeDefinitionRegistry load() {
        return SchemaUtils.loadSchema(this.type, UrlSchemaLoader.readStringFromURL(this.url));
    }

    private static Reader readStringFromURL(URL url) {
        try {
            URLConnection conn = url.openConnection();
            return new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

