/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source.yaml;

import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldRename;
import com.atlassian.braid.Link;
import com.atlassian.braid.LinkArgument;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeRename;
import com.atlassian.braid.document.DocumentMapperFactory;
import com.atlassian.braid.document.DocumentMappers;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.SchemaLoader;
import com.atlassian.braid.source.StringSchemaLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class YamlRemoteSchemaSourceBuilder {
    public static SchemaLoader buildSchemaLoader(Map<String, Object> m) {
        return new StringSchemaLoader(SchemaLoader.Type.IDL, (String)m.get("schema"));
    }

    public static SchemaNamespace buildSchemaNamespace(Map<String, Object> m) {
        return SchemaNamespace.of((String)m.get("namespace"));
    }

    public static List<FieldRename> buildQueryFieldRenames(Map<String, Object> m) {
        return Optional.of(BraidMaps.get(m, "queryFields").orElse(BraidMaps.get(m, "topLevelFields").orElse(Collections.emptyList()))).map(YamlRemoteSchemaSourceBuilder::getFieldAliasesFromObject).orElseThrow(IllegalStateException::new);
    }

    public static List<FieldRename> buildMutationAliases(Map<String, Object> m) {
        return Optional.of(BraidMaps.get(m, "mutationFields").orElse(Collections.emptyList())).map(YamlRemoteSchemaSourceBuilder::getFieldAliasesFromObject).orElseThrow(IllegalStateException::new);
    }

    public static List<TypeRename> buildTypeRenames(Map<String, Object> m) {
        return BraidMaps.get(m, "typeAliases").map(BraidObjects::cast).orElse(Collections.emptyMap()).entrySet().stream().map(entry -> TypeRename.from((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public static List<Link> buildLinks(Map<String, Object> m) {
        SchemaNamespace fromNamespace = SchemaNamespace.of((String)YamlRemoteSchemaSourceBuilder.getOrThrow(m, "namespace"));
        List simpleLinks = BraidMaps.get(m, "links").map(BraidObjects::cast).map(links -> YamlRemoteSchemaSourceBuilder.buildSimpleLinks(fromNamespace, links)).orElse(Collections.emptyList());
        return Stream.concat(simpleLinks.stream(), YamlRemoteSchemaSourceBuilder.buildComplexLinks(fromNamespace, m)).collect(Collectors.toList());
    }

    public static Stream<Link> buildComplexLinks(SchemaNamespace fromNamespace, Map<String, Object> m) {
        return BraidMaps.get(m, "complexLinks").map(BraidObjects::cast).orElse(Collections.emptyList()).stream().map(link -> YamlRemoteSchemaSourceBuilder.buildComplexLink(fromNamespace, link));
    }

    public static List<Extension> buildExtensions(Map<String, Object> m) {
        return BraidMaps.get(m, "extensions").map(BraidObjects::cast).map(YamlRemoteSchemaSourceBuilder::buildExtensions).orElse(Collections.emptyList());
    }

    public static String buildOperationNamePrefix(Map<String, Object> m) {
        return YamlRemoteSchemaSourceBuilder.getOrDefault(m, "operationNamePrefix", null);
    }

    private static List<Extension> buildExtensions(List<Map<String, Object>> extensions) {
        return extensions.stream().map(YamlRemoteSchemaSourceBuilder::buildExtension).collect(Collectors.toList());
    }

    private static Extension buildExtension(Map<String, Object> e) {
        return new Extension((String)YamlRemoteSchemaSourceBuilder.getOrThrow(e, "type"), (String)YamlRemoteSchemaSourceBuilder.getOrThrow(e, "field"), YamlRemoteSchemaSourceBuilder.buildExtensionBy((Map)YamlRemoteSchemaSourceBuilder.getOrThrow(e, "by")));
    }

    private static Extension.By buildExtensionBy(Map<String, Object> by) {
        return new Extension.By(SchemaNamespace.of((String)YamlRemoteSchemaSourceBuilder.getOrThrow(by, "namespace")), (String)YamlRemoteSchemaSourceBuilder.getOrThrow(by, "type"), (String)YamlRemoteSchemaSourceBuilder.getOrThrow(by, "query"), (String)YamlRemoteSchemaSourceBuilder.getOrThrow(by, "arg"));
    }

    public static DocumentMapperFactory buildDocumentMapperFactory(Map<String, Object> m) {
        return BraidMaps.get(m, "mapper").map(BraidObjects::cast).map(DocumentMappers::fromYamlList).orElse(DocumentMappers.identity());
    }

    private static List<FieldRename> getFieldAliasesFromObject(Object fields) {
        if (fields instanceof List) {
            return ((List)fields).stream().map(f -> FieldRename.from(f, f)).collect(Collectors.toList());
        }
        if (fields instanceof Map) {
            return ((Map)fields).entrySet().stream().map(entry -> FieldRename.from((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Unexpected field type");
    }

    private static List<Link> buildSimpleLinks(SchemaNamespace fromNamespace, List<Map<String, Map<String, Object>>> links) {
        return links.stream().map(l -> YamlRemoteSchemaSourceBuilder.buildLink(fromNamespace, l)).collect(Collectors.toList());
    }

    private static Link buildLink(SchemaNamespace fromNamespace, Map<String, Map<String, Object>> linkMap) {
        Map from = (Map)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "from");
        Map to = (Map)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "to");
        Link.LinkBuilder linkBuilder = YamlRemoteSchemaSourceBuilder.buildFrom(fromNamespace, from);
        linkBuilder = YamlRemoteSchemaSourceBuilder.buildTo(linkBuilder, to);
        if (YamlRemoteSchemaSourceBuilder.getReplaceFromField(linkMap)) {
            linkBuilder.replaceFromField();
        }
        BraidMaps.get(to, "argument").map(Object::toString).ifPresent(linkBuilder::argument);
        BraidMaps.get(to, "nullable").map(val -> {
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return Boolean.valueOf((String)val);
        }).ifPresent(linkBuilder::setNullable);
        return linkBuilder.build();
    }

    private static Link buildComplexLink(SchemaNamespace fromNamespace, Map<String, Object> linkMap) {
        Link.ComplexLinkBuilder linkBuilder = Link.newComplexLink();
        ((Link.ComplexLinkBuilder)((Link.ComplexLinkBuilder)((Link.ComplexLinkBuilder)((Link.ComplexLinkBuilder)((Link.ComplexLinkBuilder)linkBuilder.sourceNamespace(fromNamespace)).sourceType((String)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "sourceType"))).targetType((String)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "targetType"), YamlRemoteSchemaSourceBuilder.getOrDefault(linkMap, "targetNonNullable", false))).targetNamespace(SchemaNamespace.of((String)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "targetNamespace")))).topLevelQueryField((String)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "topLevelQueryField"))).newFieldName((String)YamlRemoteSchemaSourceBuilder.getOrThrow(linkMap, "field"));
        BraidMaps.get(linkMap, "arguments").map(BraidObjects::cast).orElse(Collections.emptyList()).stream().map(YamlRemoteSchemaSourceBuilder::buildLinkArgument).forEach(linkBuilder::linkArgument);
        return linkBuilder.build();
    }

    private static LinkArgument buildLinkArgument(Map<String, Object> argumentMap) {
        return LinkArgument.newLinkArgument().nullable(YamlRemoteSchemaSourceBuilder.getOrDefault(argumentMap, "nullable", true)).removeInputField(YamlRemoteSchemaSourceBuilder.getOrDefault(argumentMap, "removeInputField", false)).sourceName((String)YamlRemoteSchemaSourceBuilder.getOrThrow(argumentMap, "sourceName")).targetFieldMatchingArgument(YamlRemoteSchemaSourceBuilder.getOrDefault(argumentMap, "targetFieldMatchingArgument", null)).queryArgumentName((String)YamlRemoteSchemaSourceBuilder.getOrThrow(argumentMap, "queryArgumentName")).argumentSource(LinkArgument.ArgumentSource.valueOf((String)YamlRemoteSchemaSourceBuilder.getOrThrow(argumentMap, "argumentSource"))).build();
    }

    private static Link.LinkBuilder buildFrom(SchemaNamespace fromNamespace, Map<String, String> from) {
        String fromField = (String)YamlRemoteSchemaSourceBuilder.getOrThrow(from, "field");
        return Link.from(fromNamespace, (String)YamlRemoteSchemaSourceBuilder.getOrThrow(from, "type"), fromField, BraidMaps.get(from, "fromField").orElse(fromField));
    }

    private static Link.LinkBuilder buildTo(Link.LinkBuilder builder, Map<String, Object> to) {
        return ((Link.LinkBuilder)((Link.LinkBuilder)((Link.LinkBuilder)builder.targetNamespace(SchemaNamespace.of((String)YamlRemoteSchemaSourceBuilder.getOrThrow(to, "namespace")))).targetType((String)YamlRemoteSchemaSourceBuilder.getOrThrow(to, "type"), YamlRemoteSchemaSourceBuilder.getOrDefault(to, "targetNonNullable", false))).topLevelQueryField(BraidMaps.get(to, "field").map(Objects::toString).orElse(null))).targetFieldMatchingQueryArgument(BraidMaps.get(to, "variableField").map(Objects::toString).orElse(null));
    }

    private static <T> T getOrThrow(Map<String, ?> map, String key) {
        return (T)BraidMaps.get(map, key).map(BraidObjects::cast).orElseThrow(IllegalStateException::new);
    }

    private static <T> T getOrDefault(Map<String, ?> map, String key, T defaultValue) {
        return (T)BraidMaps.get(map, key).map(BraidObjects::cast).orElse(defaultValue);
    }

    private static boolean getReplaceFromField(Map<String, Map<String, Object>> link) {
        return BraidMaps.get(link.get("from"), "replaceFromField").map(BraidObjects::cast).orElse(false);
    }
}

