/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.ArgumentValueProvider;
import com.atlassian.braid.DefaultArgumentValueProvider;
import com.atlassian.braid.LinkArgument;
import com.atlassian.braid.SchemaNamespace;
import graphql.execution.DataFetcherResult;
import graphql.language.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Link {
    private final SchemaNamespace sourceNamespace;
    private final String sourceType;
    private final SchemaNamespace targetNamespace;
    private final String targetType;
    private final String newFieldName;
    private final String topLevelQueryField;
    private final boolean simpleLink;
    private final List<LinkArgument> linkArguments;
    private final Set<String> queryFieldsMatchingArguments;
    private final ArgumentValueProvider argumentValueProvider;
    private final boolean noSchemaChangeNeeded;
    private final CustomTransformation customTransformation;

    public Link(SchemaNamespace sourceNamespace, String sourceType, SchemaNamespace targetNamespace, String targetType, String newFieldName, String topLevelQueryField, boolean noSchemaChangeNeeded, List<LinkArgument> linkArguments, CustomTransformation customTransformation, boolean isSimpleLink, ArgumentValueProvider argumentValueProvider) {
        this.sourceNamespace = Objects.requireNonNull(sourceNamespace);
        this.sourceType = Objects.requireNonNull(sourceType);
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
        this.targetType = Objects.requireNonNull(targetType);
        this.newFieldName = Objects.requireNonNull(newFieldName);
        this.topLevelQueryField = Objects.requireNonNull(topLevelQueryField);
        this.linkArguments = Objects.requireNonNull(linkArguments, "linkArguments");
        this.noSchemaChangeNeeded = noSchemaChangeNeeded;
        this.simpleLink = isSimpleLink;
        this.customTransformation = customTransformation;
        this.argumentValueProvider = argumentValueProvider == null ? DefaultArgumentValueProvider.INSTANCE : argumentValueProvider;
        this.queryFieldsMatchingArguments = this.linkArguments.stream().map(LinkArgument::getTargetFieldMatchingArgument).collect(Collectors.toSet());
        this.ensureLinkIsValid();
    }

    private void ensureLinkIsValid() {
        if (this.simpleLink) {
            if (this.linkArguments.size() != 1) {
                throw new IllegalArgumentException("Simple link requires exactly one LinkArgument.");
            }
            if (this.linkArguments.get(0).getArgumentSource() != LinkArgument.ArgumentSource.OBJECT_FIELD) {
                throw new IllegalArgumentException("Simple link requires argument sourced to be of type OBJECT FIELD");
            }
        }
    }

    @Deprecated
    public static LinkBuilder from(SchemaNamespace sourceNamespace, String sourceType, String newFieldName) {
        return (LinkBuilder)((LinkBuilder)((LinkBuilder)Link.newLink().sourceNamespace(sourceNamespace)).sourceType(sourceType)).newFieldName(newFieldName);
    }

    @Deprecated
    public static LinkBuilder from(SchemaNamespace sourceNamespace, String sourceType, String newFieldName, String sourceInputFieldName) {
        return ((LinkBuilder)((LinkBuilder)((LinkBuilder)Link.newLink().sourceNamespace(sourceNamespace)).sourceType(sourceType)).newFieldName(newFieldName)).sourceInputFieldName(sourceInputFieldName);
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public SchemaNamespace getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public boolean isSimpleLink() {
        return this.simpleLink;
    }

    public SchemaNamespace getSourceNamespace() {
        return this.sourceNamespace;
    }

    public String getNewFieldName() {
        return this.newFieldName;
    }

    public String getTopLevelQueryField() {
        return this.topLevelQueryField;
    }

    public String getQueryArgumentName() {
        return this.getSimpleLinkArgument().getQueryArgumentName();
    }

    public String getSourceInputFieldName() {
        return this.getSimpleLinkArgument().getSourceName();
    }

    public LinkArgument getSimpleLinkArgument() {
        if (!this.simpleLink) {
            throw new IllegalStateException("Not a simple link.");
        }
        return this.linkArguments.get(0);
    }

    public List<LinkArgument> getLinkArguments() {
        return this.linkArguments;
    }

    public boolean isFieldMatchingArgument(String fieldName) {
        return this.queryFieldsMatchingArguments.contains(fieldName);
    }

    public boolean isNoSchemaChangeNeeded() {
        return this.noSchemaChangeNeeded;
    }

    public CustomTransformation getCustomTransformation() {
        return this.customTransformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.sourceNamespace, link.sourceNamespace) && Objects.equals(this.sourceType, link.sourceType) && Objects.equals(this.targetNamespace, link.targetNamespace) && Objects.equals(this.targetType, link.targetType) && Objects.equals(this.newFieldName, link.newFieldName) && Objects.equals(this.topLevelQueryField, link.topLevelQueryField) && Objects.equals(this.linkArguments, link.linkArguments);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNamespace, this.sourceType, this.targetNamespace, this.targetType, this.newFieldName, this.topLevelQueryField, this.linkArguments);
    }

    public String toString() {
        return "Link{sourceNamespace=" + this.sourceNamespace + ", sourceType='" + this.sourceType + '\'' + ", targetNamespace=" + this.targetNamespace + ", targetType='" + this.targetType + '\'' + ", newFieldName='" + this.newFieldName + '\'' + ", topLevelQueryField='" + this.topLevelQueryField + '\'' + ", linkArguments=" + this.linkArguments + ", simpleLink=" + this.simpleLink + '}';
    }

    public static LinkBuilder newLink() {
        return new LinkBuilder();
    }

    public static LinkBuilder newSimpleLink() {
        return new LinkBuilder();
    }

    public static ComplexLinkBuilder newComplexLink() {
        return new ComplexLinkBuilder();
    }

    public ArgumentValueProvider getArgumentValueProvider() {
        return this.argumentValueProvider;
    }

    public static final class ComplexLinkBuilder
    extends BaseLinkBuilder<ComplexLinkBuilder> {
        private ArgumentValueProvider argumentValueProvider = DefaultArgumentValueProvider.INSTANCE;
        private final List<LinkArgument> linkArguments = new ArrayList<LinkArgument>();

        public ComplexLinkBuilder linkArgument(LinkArgument argument) {
            this.linkArguments.add(Objects.requireNonNull(argument, "argument"));
            return this;
        }

        public ComplexLinkBuilder linkArguments(Collection<LinkArgument> linkArguments) {
            this.linkArguments.addAll(Objects.requireNonNull(linkArguments, "linkArguments"));
            return this;
        }

        public ComplexLinkBuilder linkArgument(Consumer<LinkArgument.LinkArgumentBuilder> argumentBuilderConsumer) {
            LinkArgument.LinkArgumentBuilder argumentBuilder = LinkArgument.newLinkArgument();
            Objects.requireNonNull(argumentBuilderConsumer, "argumentBuilderConsumer").accept(argumentBuilder);
            this.linkArguments.add(argumentBuilder.build());
            return this;
        }

        public ComplexLinkBuilder argumentValueProvider(ArgumentValueProvider argumentValueProvider) {
            this.argumentValueProvider = Objects.requireNonNull(argumentValueProvider, "argumentValueProvider");
            return this;
        }

        @Override
        public Link build() {
            String topLevelQueryField = Optional.ofNullable(this.topLevelQueryField).orElse(this.newFieldName);
            List<LinkArgument> arguments = Collections.unmodifiableList(new ArrayList<LinkArgument>(this.linkArguments));
            return new Link(this.sourceNamespace, this.sourceType, this.targetNamespace, this.targetType, this.newFieldName, topLevelQueryField, this.noSchemeChangeNeeded, arguments, this.customTransformation, false, this.argumentValueProvider);
        }
    }

    public static final class LinkBuilder
    extends BaseLinkBuilder<LinkBuilder> {
        private String queryArgumentName;
        private String sourceInputFieldName;
        private String targetFieldMatchingQueryArgument;
        private boolean removeInputField;
        protected boolean nullable;

        private LinkBuilder() {
        }

        @Deprecated
        public LinkBuilder to(SchemaNamespace targetNamespace, String targetType) {
            return this.to(targetNamespace, targetType, null);
        }

        @Deprecated
        public LinkBuilder to(SchemaNamespace targetNamespace, String targetType, String topLevelQueryField) {
            return this.to(targetNamespace, targetType, topLevelQueryField, null);
        }

        @Deprecated
        public LinkBuilder to(SchemaNamespace targetNamespace, String targetType, String topLevelQueryField, String targetFieldMatchingQueryArgument) {
            this.targetNamespace = targetNamespace;
            this.targetType = targetType;
            this.topLevelQueryField = topLevelQueryField;
            this.targetFieldMatchingQueryArgument = targetFieldMatchingQueryArgument;
            return this;
        }

        public LinkBuilder removeInputField(boolean removeInputField) {
            this.removeInputField = removeInputField;
            return this;
        }

        @Deprecated
        public LinkBuilder replaceFromField() {
            return this.removeInputField(true);
        }

        @Deprecated
        public LinkBuilder argument(String queryArgumentName) {
            return this.queryArgumentName(queryArgumentName);
        }

        public LinkBuilder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public LinkBuilder queryArgumentName(String queryArgumentName) {
            this.queryArgumentName = queryArgumentName;
            return this;
        }

        public LinkBuilder sourceInputFieldName(String sourceInputFieldName) {
            this.sourceInputFieldName = sourceInputFieldName;
            return this;
        }

        public LinkBuilder targetFieldMatchingQueryArgument(String targetFieldMatchingQueryArgument) {
            this.targetFieldMatchingQueryArgument = targetFieldMatchingQueryArgument;
            return this;
        }

        @Override
        public Link build() {
            Objects.requireNonNull(this.sourceNamespace);
            Objects.requireNonNull(this.sourceType);
            Objects.requireNonNull(this.targetNamespace);
            Objects.requireNonNull(this.targetType);
            Objects.requireNonNull(this.newFieldName);
            String topLevelQueryField = Optional.ofNullable(this.topLevelQueryField).orElse(this.newFieldName);
            String sourceInputFieldName = Optional.ofNullable(this.sourceInputFieldName).orElse(this.newFieldName);
            String queryArgumentName = Optional.ofNullable(this.queryArgumentName).orElse("id");
            String targetFieldMatchingQueryArgument = Optional.ofNullable(this.targetFieldMatchingQueryArgument).orElse(queryArgumentName);
            LinkArgument linkArgument = LinkArgument.newLinkArgument().argumentSource(LinkArgument.ArgumentSource.OBJECT_FIELD).queryArgumentName(queryArgumentName).targetFieldMatchingArgument(targetFieldMatchingQueryArgument).sourceName(sourceInputFieldName).removeInputField(this.removeInputField).nullable(this.nullable).build();
            return new Link(this.sourceNamespace, this.sourceType, this.targetNamespace, this.targetType, this.newFieldName, topLevelQueryField, this.noSchemeChangeNeeded, Collections.singletonList(linkArgument), this.customTransformation, true, DefaultArgumentValueProvider.INSTANCE);
        }
    }

    private static abstract class BaseLinkBuilder<T extends BaseLinkBuilder<T>> {
        protected SchemaNamespace targetNamespace;
        protected String targetType;
        protected String topLevelQueryField;
        protected SchemaNamespace sourceNamespace;
        protected String sourceType;
        protected String newFieldName;
        protected boolean noSchemeChangeNeeded;
        protected CustomTransformation customTransformation;

        private BaseLinkBuilder() {
        }

        public T sourceNamespace(SchemaNamespace sourceNamespace) {
            this.sourceNamespace = sourceNamespace;
            return (T)this;
        }

        public T targetNamespace(SchemaNamespace targetNamespace) {
            this.targetNamespace = targetNamespace;
            return (T)this;
        }

        public T targetType(String targetType) {
            this.targetType = targetType;
            return (T)this;
        }

        public T topLevelQueryField(String topLevelQueryField) {
            this.topLevelQueryField = topLevelQueryField;
            return (T)this;
        }

        public T sourceType(String sourceType) {
            this.sourceType = sourceType;
            return (T)this;
        }

        public T newFieldName(String newFieldName) {
            this.newFieldName = newFieldName;
            return (T)this;
        }

        public T noSchemaChangeNeeded(boolean noSchemeChangeNeeded) {
            this.noSchemeChangeNeeded = noSchemeChangeNeeded;
            return (T)this;
        }

        public T customTransformation(CustomTransformation customTransformation) {
            this.customTransformation = customTransformation;
            return (T)this;
        }

        public abstract Link build();
    }

    public static interface CustomTransformation {
        public void createQuery(Field var1, Object var2);

        public DataFetcherResult<Object> unapplyForResult(Field var1, DataFetcherResult<Object> var2);
    }
}

