/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.LinkArgument;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.transformation.BraidSchemaSource;
import graphql.analysis.QueryTraversal;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TrimFieldsSelection {
    public static List<FragmentDefinition> trimFieldSelection(final SchemaSource schemaSource, DataFetchingEnvironment environment, Node root, final boolean ignoreFirstField) {
        final ArrayList fieldWithLinks = new ArrayList();
        final BraidSchemaSource braidSchemaSource = new BraidSchemaSource(schemaSource);
        QueryVisitorStub nodeVisitor = new QueryVisitorStub(){

            public void visitField(QueryVisitorFieldEnvironment env) {
                boolean isFirstField;
                if (env.isTypeNameIntrospectionField()) {
                    return;
                }
                GraphQLFieldsContainer parentFieldsContainer = env.getFieldsContainer();
                Field field = env.getField();
                boolean bl = isFirstField = env.getParentEnvironment() == null;
                if (isFirstField && ignoreFirstField) {
                    return;
                }
                Optional linkForField = TrimFieldsSelection.getLinkForField(braidSchemaSource, schemaSource.getLinks(), parentFieldsContainer.getName(), field.getName());
                linkForField.ifPresent(link -> {
                    SelectionSet parentSelectionSet = Optional.ofNullable(env.getSelectionSetContainer()).map(SelectionSetContainer::getSelectionSet).orElse(null);
                    fieldWithLinks.add(new FieldWithLink(field, (Link)link, parentSelectionSet));
                });
            }
        };
        Map<String, FragmentDefinition> fragmentsByName = environment.getFragmentsByName().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FragmentDefinition)entry.getValue()).deepCopy()));
        QueryTraversal queryTraversal = QueryTraversal.newQueryTraversal().schema(environment.getGraphQLSchema()).root(root).rootParentType((GraphQLObjectType)environment.getParentType()).fragmentsByName(fragmentsByName).variables(environment.getExecutionContext().getVariables()).build();
        queryTraversal.visitPreOrder((QueryVisitor)nodeVisitor);
        fieldWithLinks.forEach(TrimFieldsSelection::addLinkArgumentsToSourceSelections);
        LinkedHashSet<FragmentDefinition> referencedFragments = new LinkedHashSet<FragmentDefinition>();
        TrimFieldsSelection.getReferencedFragments(root, fragmentsByName, referencedFragments);
        return new ArrayList<FragmentDefinition>(referencedFragments);
    }

    private static void addLinkArgumentsToSourceSelections(FieldWithLink fieldWithLink) {
        SelectionSet parentSelectionSet = fieldWithLink.parentSelectionSet;
        if (parentSelectionSet == null) {
            LinkArgument linkArgument = fieldWithLink.link.getLinkArguments().stream().filter(argument -> argument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Link for top level field '%s' requires exactly one object field argument", fieldWithLink.link.getNewFieldName())));
            fieldWithLink.field.setSelectionSet(null);
            fieldWithLink.field.setName(linkArgument.getSourceName());
            return;
        }
        parentSelectionSet.getSelections().remove(fieldWithLink.field);
        fieldWithLink.link.getLinkArguments().stream().filter(argument -> argument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD).forEach(argument -> {
            Field newField = Field.newField().name(argument.getSourceName()).build();
            if (!TrimFieldsSelection.selectionSetContainsField(parentSelectionSet, newField)) {
                parentSelectionSet.getSelections().add(newField);
            }
        });
    }

    private static boolean selectionSetContainsField(SelectionSet selectionSet, Field fieldToCheck) {
        return selectionSet.getSelections().stream().filter(selection -> selection instanceof Field).map(field -> (Field)field).anyMatch(field -> field.getName().equals(fieldToCheck.getName()) && Objects.equals(field.getAlias(), fieldToCheck.getAlias()));
    }

    private static void getReferencedFragments(Node root, final Map<String, FragmentDefinition> fragmentDefinitionMap, Set<FragmentDefinition> referencedFragments) {
        final LinkedHashSet childFragments = new LinkedHashSet();
        NodeVisitorStub nodeVisitorStub = new NodeVisitorStub(){

            public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
                childFragments.add(fragmentDefinitionMap.get(fragmentSpread.getName()));
                return TraversalControl.CONTINUE;
            }
        };
        new NodeTraverser().preOrder((NodeVisitor)nodeVisitorStub, root);
        childFragments.stream().filter(referencedFragments::add).forEach(frag -> TrimFieldsSelection.getReferencedFragments((Node)frag, fragmentDefinitionMap, referencedFragments));
    }

    private static Optional<Link> getLinkForField(BraidSchemaSource braidSchemaSource, Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> braidSchemaSource.getLinkBraidSourceType((Link)l).equals(typeName) && l.getNewFieldName().equals(fieldName)).findFirst();
    }

    private static class FieldWithLink {
        public final Field field;
        public final Link link;
        public final SelectionSet parentSelectionSet;

        public FieldWithLink(Field field, Link link, SelectionSet parentSelectionSet) {
            this.field = field;
            this.link = link;
            this.parentSelectionSet = parentSelectionSet;
        }
    }
}

