/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.document.SelectionOperation;
import com.atlassian.braid.document.SelectionSetMappingResult;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import java.util.Objects;

abstract class SelectionMapper<C> {
    SelectionMapper() {
    }

    static SelectionMapper getSelectionMapper(Selection selection) {
        if (selection instanceof Field) {
            return new FieldMapper((Field)selection);
        }
        if (selection instanceof FragmentSpread) {
            return new FragmentSpreadMapper((FragmentSpread)selection);
        }
        if (selection instanceof InlineFragment) {
            return new InlineFragmentMapper((InlineFragment)selection);
        }
        throw new IllegalStateException("Unknown selection type: " + selection.getClass());
    }

    abstract SelectionOperation.OperationResult map(MappingContext<C> var1);

    private static class InlineFragmentMapper<C>
    extends SelectionMapper<C> {
        private final InlineFragment inlineFragment;

        public InlineFragmentMapper(InlineFragment inlineFragment) {
            this.inlineFragment = Objects.requireNonNull(inlineFragment);
        }

        @Override
        SelectionOperation.OperationResult map(MappingContext<C> mappingContext) {
            MappingContext inlineFragmentMappingContext = mappingContext.forInlineFragment(this.inlineFragment);
            return inlineFragmentMappingContext.getTypeMapper().map((? super T typeMapper) -> (SelectionSetMappingResult)typeMapper.apply(inlineFragmentMappingContext, this.inlineFragment.getSelectionSet())).map((? super T mappingResult) -> mappingResult.toOperationResult(this.inlineFragment)).orElseGet(() -> SelectionOperation.result((Selection)this.inlineFragment));
        }
    }

    private static class FragmentSpreadMapper<C>
    extends SelectionMapper<C> {
        private final FragmentSpread fragmentSpread;

        private FragmentSpreadMapper(FragmentSpread fragmentSpread) {
            this.fragmentSpread = Objects.requireNonNull(fragmentSpread);
        }

        @Override
        SelectionOperation.OperationResult map(MappingContext<C> mappingContext) {
            FragmentDefinition fragmentDefinition = mappingContext.getFragmentDefinition(this.fragmentSpread);
            return mappingContext.getTypeMapper().map((? super T tm) -> (SelectionSetMappingResult)tm.apply(mappingContext, fragmentDefinition.getSelectionSet())).map((? super T mappingResult) -> mappingResult.toOperationResult(this.fragmentSpread)).orElseGet(() -> SelectionOperation.result((Selection)this.fragmentSpread));
        }
    }

    private static class FieldMapper<C>
    extends SelectionMapper<C> {
        private final Field field;

        private FieldMapper(Field field) {
            this.field = Objects.requireNonNull(field);
        }

        @Override
        SelectionOperation.OperationResult map(MappingContext<C> mappingContext) {
            MappingContext fieldMappingContext = mappingContext.forField(this.field);
            return fieldMappingContext.getTypeMapper().map((? super T typeMapper) -> (SelectionSetMappingResult)typeMapper.apply(fieldMappingContext, this.field.getSelectionSet())).map((? super T mappingResult) -> mappingResult.toOperationResult(this.field, fieldMappingContext)).orElseGet(() -> SelectionOperation.result((Selection)this.field));
        }
    }
}

