package com.atlassian.braid;

import graphql.language.Field;
import org.dataloader.DataLoaderRegistry;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.util.Objects.requireNonNull;

final class MutableBraidContext<C> implements BraidContext<C> {
    private final DataLoaderRegistry dataLoaderRegistry;
    private final Map<String, List<Field>> missingFieldsByType = new HashMap<>();

    @Nullable
    private final C context;

    MutableBraidContext(@Nonnull DataLoaderRegistry dataLoaderRegistry, @Nullable C context) {
        this.dataLoaderRegistry = requireNonNull(dataLoaderRegistry);
        this.context = context;
    }

    @Override
    public void addMissingFields(String typeName, List<Field> fields) {
        this.missingFieldsByType.put(typeName, fields);
    }

    @Override
    public List<Field> getMissingFields(String typeName) {
        return missingFieldsByType.get(typeName);
    }

    @Override
    public DataLoaderRegistry getDataLoaderRegistry() {
        return dataLoaderRegistry;
    }

    @Override
    public C getContext() {
        return context;
    }
}
