package com.atlassian.braid;

import graphql.language.Field;
import org.dataloader.DataLoaderRegistry;

import java.util.List;

/**
 * <p>Defines the context of Braid GraphQL execution, from which the underlying context can be retrieved.
 * <p>Note: this class is for Braid's internal usage, and should not be used directly. Use methods on
 * {@link BraidContexts} to access context information
 *
 * @see BraidContexts
 */
public interface BraidContext<C> {

    void addMissingFields(String typeName, List<Field> fields);

    List<Field> getMissingFields(String typeName);

    /**
     * @return the data loader registry for this request, since new instances may be created per-request.
     */
    DataLoaderRegistry getDataLoaderRegistry();

    /**
     * @return the underlying user set context
     */
    C getContext();
}
