/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.DataFetcherUtils;
import com.atlassian.braid.transformation.LinkTransformation;
import com.atlassian.braid.transformation.SchemaTransformation;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dataloader.BatchLoader;

public class LinkSchemaTransformation
implements SchemaTransformation {
    @Override
    public Map<String, BatchLoader> transform(BraidingContext braidingContext) {
        return LinkSchemaTransformation.linkTypes(braidingContext.getDataSources(), braidingContext.getQueryObjectTypeDefinition(), braidingContext.getMutationObjectTypeDefinition(), braidingContext.getRuntimeWiringBuilder(), braidingContext.getBatchLoaderEnvironment());
    }

    private static Map<String, BatchLoader> linkTypes(Map<SchemaNamespace, BraidSchemaSource> sources, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, RuntimeWiring.Builder runtimeWiringBuilder, BatchLoaderEnvironment batchLoaderEnvironment) {
        HashMap<String, BatchLoader> batchLoaders = new HashMap<String, BatchLoader>();
        for (BraidSchemaSource source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = source.getTypeRegistry();
            TypeDefinitionRegistry privateTypes = source.getSchemaSource().getPrivateSchema();
            HashMap<String, TypeDefinition> dsTypes = new HashMap<String, TypeDefinition>(typeRegistry.types());
            for (Link link : source.getSchemaSource().getLinks()) {
                ObjectTypeDefinition sourceObjectTypeDefinition = LinkSchemaTransformation.getObjectTypeDefinition(queryObjectTypeDefinition, mutationObjectTypeDefinition, typeRegistry, dsTypes, source.getLinkBraidSourceType(link));
                LinkSchemaTransformation.validateSourceFromFieldExists(link, privateTypes);
                Optional<FieldDefinition> newField = sourceObjectTypeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getNewFieldName())).findFirst();
                Optional<FieldDefinition> sourceInputField = sourceObjectTypeDefinition.getFieldDefinitions().stream().filter(Objects::nonNull).filter(s -> s.getName().equals(link.getSourceInputFieldName())).findAny();
                BraidSchemaSource targetSource = sources.get(link.getTargetNamespace());
                if (targetSource == null) {
                    throw new IllegalArgumentException("Can't find target schema source: " + link.getTargetNamespace());
                }
                if (!targetSource.hasType(link.getTargetType())) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                if (!link.isNoSchemaChangeNeeded()) {
                    LinkSchemaTransformation.modifySchema(link, sourceObjectTypeDefinition, newField, sourceInputField);
                }
                String type = source.getLinkBraidSourceType(link);
                String field = link.getNewFieldName();
                String linkDataLoaderKey = DataFetcherUtils.getLinkDataLoaderKey(type, field);
                DataFetcher dataFetcher = env -> ((BraidContext)env.getContext()).getDataLoaderRegistry().getDataLoader(linkDataLoaderKey).load((Object)env);
                runtimeWiringBuilder.type(type, wiring -> wiring.dataFetcher(field, dataFetcher));
                BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = targetSource.getSchemaSource().newBatchLoader(targetSource.getSchemaSource(), new LinkTransformation(link), batchLoaderEnvironment);
                batchLoaders.put(linkDataLoaderKey, batchLoader);
            }
        }
        return batchLoaders;
    }

    private static void modifySchema(Link link, ObjectTypeDefinition typeDefinition, Optional<FieldDefinition> newField, Optional<FieldDefinition> sourceInputField) {
        if (sourceInputField.isPresent() && link.isRemoveInputField()) {
            typeDefinition.getFieldDefinitions().remove(sourceInputField.get());
        }
        TypeName targetType = new TypeName(link.getTargetType());
        if (!newField.isPresent()) {
            if (sourceInputField.isPresent() && LinkSchemaTransformation.isListType(sourceInputField.get().getType())) {
                targetType = new ListType((Type)targetType);
            }
            FieldDefinition field = new FieldDefinition(link.getSourceField(), (Type)targetType);
            typeDefinition.getFieldDefinitions().add(field);
        } else if (LinkSchemaTransformation.isListType(newField.get().getType())) {
            if (newField.get().getType() instanceof NonNullType) {
                newField.get().setType((Type)new NonNullType((Type)new ListType((Type)targetType)));
            } else {
                newField.get().setType((Type)new ListType((Type)targetType));
            }
        } else {
            newField.get().setType((Type)targetType);
        }
    }

    private static ObjectTypeDefinition getObjectTypeDefinition(ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, TypeDefinitionRegistry typeRegistry, Map<String, TypeDefinition> dsTypes, String linkSourceType) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(linkSourceType);
        if (typeDefinition == null && linkSourceType.equals(queryObjectTypeDefinition.getName()) && (typeDefinition = (ObjectTypeDefinition)TypeUtils.findQueryType(typeRegistry).orElse(null)) == null && linkSourceType.equals(mutationObjectTypeDefinition.getName())) {
            typeDefinition = TypeUtils.findMutationType(typeRegistry).orElse(null);
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Can't find source type: " + linkSourceType);
        }
        return typeDefinition;
    }

    private static void validateSourceFromFieldExists(Link link, TypeDefinitionRegistry privateTypeDefinitionRegistry) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)privateTypeDefinitionRegistry.getType(link.getSourceType(), ObjectTypeDefinition.class).orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source type '%s' in private schema for link %s", link.getSourceType(), link.getSourceField())));
        typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceFromField())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source from field: %s", link.getSourceFromField())));
    }

    private static boolean isListType(Type type) {
        return type instanceof ListType || type instanceof NonNullType && ((NonNullType)type).getType() instanceof ListType;
    }
}

